-- Option matcher that allows variable option identifiers.

indexing
	
	type: user;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 19:55:35 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: VARMATCH.E $
	-- Revision 1.2  1993/06/24  19:55:35  Neil_Wilson
	-- Corrected index type and header comments
	--
	-- Revision 1.1  1993/06/20  12:36:09  Neil_Wilson
	-- Initial revision
	-- 

class VARIABLE_FULL_MATCHER

inherit
		
	FULL_MATCHER

creation

	make
	
feature -- Build the matcher

	make (mat: OPTION_IDENTIFIER) is
		-- Build internal objects
	require
		match_available: mat /= Void
	do
		match := mat;
		!SHORT_SORTED_LIST [STRING]!simple.make (true);
		!SHORT_SORTED_TABLE [STRING, STRING]!param_list.make (true);
		!SHORT_SORTED_TABLE [STRING, STRING]!optional_list.make (true);
	end -- make

	change (opt: OPTION_IDENTIFIER) is
		-- Use a new option identifier
	require
		opt /= Void
	do
		match := opt
	ensure
		match = opt
	end -- change

feature -- Identifier manipulators

	is_option_string (arg: STRING): BOOLEAN is
	do
		Result := match.is_option_string (arg)
	end -- is_option_string

	remove_option_marker (arg: STRING): STRING is
	do
		Result := match.remove_option_marker (arg)
	end -- remove_option_marker

	add_option_marker (arg: STRING): STRING is
	do
		Result := match.add_option_marker (arg)
	end -- add_option_marker

feature {NONE}

	match: OPTION_IDENTIFIER
		-- holds current option identifier.

invariant

	match_available: match /= Void

end -- class VARIABLE_FULL_MATCHER
