class BASICS

   feature {ANY} 

      concat (s1, s2: STRING): STRING is
      -- concats two strings into result 

         require
            void_parameter: s1 /= void and then s2 /= void

         do
            Result := clone (s1)
            Result.append (s2)
         end -- concat    

      index (s: STRING, c: CHARACTER, n: INTEGER): INTEGER is
      -- index of the first occurence of c starting at position n         
      -- result is 0 if not found        

         require
            void_parameter: s /= void
            index_to_small: n >= 1
            index_to_big: n < s.count

         local
            i: INTEGER

         do
            from i := n 
            until i > s.count or else s @ i = c 
            loop
               i := i + 1
            end -- loop      
            if i > s.count then
               Result := 0
            else
               Result := i
            end -- if        
         end -- index     

      l_trim (s: STRING): STRING is
      -- remove leading blanks

         require
            s /= void

         local 
            i : INTEGER

         do
            from i := 1 
            until i > s.count or else s @ i /= ' ' 
            loop
               i := i + 1
            end -- loop      
            if i < s.count then
               Result := s.substring (i, s.count) 
            else
               Result := ""
            end -- if        
         end -- l_trim    

      r_trim (s: STRING): STRING is
      -- remove trailing blanks          

         require
            s /= void

         local 
            i : INTEGER

         do
            from i := s.count 
            until i < 1 or else s @ i /= ' ' 
            loop
               i := i - 1
            end -- loop      
            if i < 1 then
               Result := ""
            else
               Result := s.substring (1, i) 
            end -- if        
         end -- r_trim    

      remove_tail (s: STRING, n: INTEGER): STRING is
      -- removes the last n chars        
      -- (delivers empty string if n >= s.count)    

         require
            void_parameter: s /= void
            wrong_number: n >= 1

         do
            if s.count > n then
               Result := s.substring (1, s.count - n)
            else
               Result := ""
            end
         end -- remove_tail          

      tail (s: STRING, n: INTEGER): STRING is
      -- delivers in result the n last chars        
      -- (or s if s.count <= n)          

         require
            void_parameter: s /= void
            wrong_number: n >= 1

         do
            if s.count > n then
               Result := s.substring (s.count - n + 1, s.count)
            else
               Result := s
            end
         end -- tail      

   end 
