class EXT_IO

-- this class gives more comfortable i/o compared with BASIC_IO     
-- for example it allows to print more than one string, character or number    
-- with one request. It also demonstrates the classes int_ref, char_ref ..     
--
-- one can extend the features by special posibilities - you can include       
-- printing your own data types, for example. 

-- in addition EXT_IO offers also all features of BASIC_IO and FORMAT          

   inherit
      BASIC_IO
      FORMAT

   feature {ANY}

      eol: CHARACTER is '%N'; 

      put (a: ARRAY[ANY]) is

         require
            no_parameter: a /= void
            ---------------------------------------------------------------------------
            -- print a list of expressions delivered as manifest array - for example       
            --    put (<<3.14, "*", 2, "=>", 3.14*2, "%N">>)      or 
            --    put (<<"Result of function is:", xyz.abc ("search"), "%N">>)  
            --
            -- put accepts BOOLEAN, INTEGER, REAL, CHARACTER and STRING elements. Other    
            -- types are ignored - but you can extend put to meet your requirements        
            --
            -- put also allows to format INTEGER, REAL and STRING parameters. The          
            -- conventions of the FORMAT class are used.  
            -- 1. a STRING starting with : is used to format the following parameter, i.e. 
            --    put (<<":6.2", 3.14 >>) delivers "   3.14".        
            -- 2. a STRING starting with :: formats all following parameters, i.e          
            --    put (<<"::6.2", 3.14, 22.1234 >>) delivers "___3.14__22.12".  
            --    this format is reset by a new :: (also with no additional parameters)    
            --    put (<<::5.0", "This is a", "x", "::", "as you see">>) gives  
            --      "This x    as you see"     
            -- 3. as long a :: format is active you can override id for the next parameter 
            --    with a : - format 
            --
            -- if you want to print a string starting with : - this should be no problem   
            -- as you can print at first the character : (as ':') and then the rest.       
            --

         local
            pb: BOOLEAN_REF
            pi: INTEGER_REF
            pr: REAL_REF
            ps: STRING
            pc: CHARACTER_REF
            i: INTEGER
            l_format, s_format: STRING 

         do
            from 
               i := a.lower 
            until 
               i > a.upper 
            loop

               -- boolean ? 
               pb ?= a @ i;
               if pb /= void then
                  put_bool (pb.item)
                  put_char (' ')
               end

               -- character 
               pc ?= a @ i;
               if pc /= void then
                  put_char (pc.item)
               end

               -- integer ? 
               pi ?= a @ i;
               if pi /= void then
                  if s_format /= void then
                     put_string ( i2s ( s_format, pi.item))
                     s_format := void
                  elseif l_format /= void then
                     put_string ( i2s ( l_format, pi.item))
                  else
                     put_int (pi.item)
                     put_char (' ')
                  end -- if        
               end -- if        

               -- real ?    
               pr ?= a @ i;
               if pr /= void then
                  if s_format /= void then
                     put_string ( r2s ( s_format, pr.item))
                     s_format := void
                  elseif l_format /= void then
                     put_string ( r2s ( l_format, pr.item))
                  else
                     put_real (pr.item)
                     put_char (' ')
                  end -- if        
               end -- if        

               -- string ?  
               ps ?= a @ i;
               if ps /= void then
                  if ps.count >= 2 and then ps.item (1) = ':' then
                     -- format    
                     if ps.item (2) = ':' then
                        -- :: format 
                        if ps.count = 2 then
                           l_format := void
                        else
                           l_format := ps.substring (3, ps.count)
                        end -- ps.count = 2         
                     else
                        -- : format  
                        if ps.count > 1 then
                           s_format := ps.substring (2, ps.count)
                        end -- if        
                     end -- if item = ':'        
                  else
                     -- not format
                     if s_format /= void then
                        put_string ( s2s ( s_format, ps))
                        s_format := void
                     elseif l_format /= void then
                        put_string ( s2s ( l_format, ps))
                     else
                        put_string (ps)
                     end -- s_format /= void     
                  end -- if        
               end -- string    

               ----------------------------------
               -- include your own types here ..  

               i := i+1
            end -- loop      
         end -- put       
   ------------------------------------

   feature {NONE}

      s2s ( f, v: STRING): STRING is

         require
            no_proper_format: f /= void and then s2r (f) > 0
            no_parameter: v /= void

         local 
            l: INTEGER
            blanks: STRING

         do
            l := s2r (f)
            if l <= v.count then
               Result := v.substring (1, l)
            else
               Result := clone (v)
               !!blanks.make (l-v.count)
               Result. append (blanks)
            end -- if        
         end -- s2s       

   end -- class     