indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/07/17 13:42:12 $";
	revision: "$Revision: 1.3 $";
	licence: "GNU GPL - see file COPYING";
	log: 
	-- $Log: construc.e $
	-- Revision 1.3  1993/07/17  13:42:12  Neil_Wilson
	-- Changed error handling sequence slightly
	-- Error is called with longer error string and
	-- no output is displayed on screen
	--
	-- Revision 1.2  1993/07/01  20:13:41  Neil_Wilson
	-- Altered to use stream based input
	--
	-- Revision 1.1  1993/06/27  09:31:57  David_Morgan
	-- Initial revision
	--
	
deferred class CONSTRUCT
-- a class for parsing eiffel constructs

feature

   l : LEXICAL is
      deferred
      end

   parse is
      deferred
      end

feature -- Connection to lexer
	-- Insert by Neil Wilson - June 27, 1993

   connect_stream (str: REWINDABLE_CHARACTER_STREAM) is
   do
   	l.connect_stream (str)
   end -- connect_stream

   	-- End of insert

   eof : BOOLEAN is
      do
         Result := l.eof
      end

   mark is
     do
        l.mark
     end

   return is
      do
         l.return
      end

   match(v : INTEGER) : BOOLEAN is
      do
         Result := l.match(v)
      end

   consume is
       do
          l.consume
       end

   matchconsume(v : INTEGER) is
      local
         t : STRING
      do
         if match(v)
         then
            consume
         else
	    -- Alteration - Neil Wilson, 10 July 1993
	    -- Change error handling sequence slightly.
	    debug
		io.putint(v)
		io.new_line
		io.putint(l.token_type)
	    end
            t := "Missing token - found '"
            t.append(l.next_token)
	    t.append("'");
            l.error(t)
	    -- End of alteration
         end -- if
      end -- matchconsume

   skip is
      do
         l.consume
      end

   matchskip(v : INTEGER) is
      do
         if match(v)
         then
            skip
         else
	    -- Alteration - Neil Wilson, 10 July 1993
            l.error("Missing token")
	    -- End of alteration
         end
      end

   ignore_comments is
      do
        l.ignore_comments
      end

   accept_comments is
      do
        l.accept_comments
      end

   error(s : STRING) is
      do
         l.error(s)
      end

   warning(s : STRING) is
      do
         l.warning(s)
      end

end -- class CONSTRUCT

