class DLLIST[G] 
-- a doubly linked list 

creation
   make

feature

   add_right(x : G) is
      require
--         x /= Void
      local
         l : like first_elem
      do
         !!l.make(x)
         if cursor /= Void
         then
            if cursor.next /= Void
            then
               cursor.next.connect_prev(l)
               l.connect_next(cursor.next)
            end
            cursor.connect_next(l)
            l.connect_prev(cursor)
            if last_elem.next /= Void
            then
               last_elem := last_elem.next
            end
         else
            first_elem := l
            last_elem := l
         end
         cursor := l
         count := count + 1
         off_left := false
         off_right := false
      end

   add_left(x : G) is
      require
--         x /= Void
      local
         l : like first_elem
      do
         !!l.make(x)
         if cursor /= Void
         then
            if cursor.prev /= Void
            then
               cursor.prev.connect_next(l)
               l.connect_prev(cursor.prev)
            end
            cursor.connect_prev(l)
            l.connect_next(cursor)
            if first_elem.prev /= Void
            then
               first_elem := first_elem.prev
            end
         else
            first_elem := l
            last_elem := l
         end
         cursor := l
         count := count + 1
         off_left := false
         off_right := false
      end
      
   put(x : G) is
      do
         finish
         add_right(x)
      end

   count : INTEGER

   first_elem : TWO_LINK[G]

   last_elem : like first_elem

   cursor : like first_elem

   remove is
   -- remove the element at the cursor
   -- move the cursor to the left
      require
         count > 0
         not off_left
         not off_right
      do
         if first_elem = last_elem
         then
            cursor := Void
            last_elem := void
            first_elem := void
            off_left := true
            off_right := true
         elseif last_elem = cursor
         then
            last_elem := cursor.prev
            last_elem.connect_next(Void)
            cursor := last_elem
         elseif first_elem = cursor
         then
            first_elem := cursor.next
            first_elem.connect_prev(Void)
            cursor := first_elem
         else
            cursor.prev.connect_next(cursor.next)
            cursor.next.connect_prev(cursor.prev)
            cursor := cursor.next
         end
         count := count - 1               
      end

   insert( x : like current) is
   -- insert the new list x
   -- at the cursor
      local
         t : like first_elem
      do
         t := cursor.next
         cursor.connect_next(x.first_elem)
         t.connect_prev(x.last_elem)
         x.first_elem.connect_prev(cursor)
         x.last_elem.connect_next(t)
         count := count + x.count
      end

   back is
      do
         cursor := cursor.prev
         off_left := cursor = Void
      end

   forth is
      do
         cursor := cursor.next
         off_right := cursor = Void
      end

   start is
      do
         cursor := first_elem
         off_right := cursor = Void
         off_left := cursor = Void
      end

   finish is
      do
         cursor := last_elem
         off_right := cursor = Void
         off_left := cursor = Void
      end

   nth(n : INTEGER):G is
      require
         n <= count
      local
         t : like first_elem
         i : INTEGER
      do
         from
            t := first_elem
            i := 1
         until
            i = n
         loop
            t := t.next
            i := i + 1
         end -- loop        
         Result := t.item
      end -- nth

   first : G is
      do
         Result := first_elem.item
      end

   last : G is
      do
         Result := last_elem.item
      end

   item : G is
      do
         Result := cursor.item
      end

   mark is
       do
          marked := cursor
          markol := off_left
          markor := off_right
       end

   return is
      do
         cursor := marked
         off_left := markol
         off_right := markor
      end

   off_left, off_right : BOOLEAN

   make is
      do
         off_left := true
         off_right := true
      end

   find(x : G) is
      do
         from
            start
         until
            cursor = Void or else item = x
         loop
            forth
         end
      end

   in(x : G) : BOOLEAN is
      local
         t : like first_elem
      do
         from
            t := first_elem
         until
            t = Void or else Result
         loop
            Result := t.item = x
            t := t.next
         end
      end

   in_equal(x : G) : BOOLEAN is
      local
         t : like first_elem
      do
         from
            t := first_elem
         until
            t = Void or else Result
         loop
            Result := equal(t.item,x)
            t := t.next
         end
      end

   remove_all is
      do
         first_elem := Void
         last_elem := Void
         cursor := Void
         off_left := true
         off_right := true   
      end

   to_array : ARRAY[G] is
       local
          i : INTEGER
       do
          !!Result.make(1,count)
          from
             i := 1
             mark
          until
             off_right
          loop
             Result.put(item,i)
             i := i + 1
             forth
          end -- loop
          return
      end -- to_array

   at_end : BOOLEAN is 
      do
         Result := cursor = last_elem
      end -- at end

   at_start : BOOLEAN is 
      do
         Result := cursor = first_elem
      end -- at start

   replace(x : G) is
      do
         cursor.put(x)
      end
      
feature {NONE}

    marked : like first_elem
    markor, markol : BOOLEAN

end -- class DLLIST
