-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:28:08 $"
	revision: "$Revision: 1.4 $";
        author : David, J, Morgan
	log: 
	-- $Log: e_assert.e $
	-- Revision 1.4  1993/08/22  12:28:08  Neil_Wilson
	-- Added 'long' feature
	-- Added call to separator
	--
	-- Revision 1.3  1993/08/01  09:43:10  David_Morgan
	-- Added missing keyword check
	--
	-- Revision 1.2  1993/07/18  13:08:16  Neil_Wilson
	-- Added 'defer' feature
	--

class EIFFEL_ASSERTION
-- A series of assertions

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end

creation
   parse
   
feature 

   clauses : LLIST[EIFFEL_CLAUSE]
   -- each assertion

   parse is
      local
         ec : EIFFEL_CLAUSE
      do
         from
            !!clauses.make
         until
            match(Elex_do) or match(Elex_end) or match(Elex_loop) or 
            match(Elex_deferred) or match(Elex_once) or match(Elex_local) or
            match(Elex_variant) or match(Elex_external) or match(Elex_rescue) or
            match(Elex_until)
         loop
            !!ec.parse
            clauses.put(ec)
            remove_semi
         end -- loop
      end -- assertion

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := clauses.is_equal(other.clauses)
      end

   copy(other : like Current) is
      do
         clauses := clone(other.clauses)
      end

   -- Alteration - Neil Wilson, July 17, 1993
   
   long, defer, flat, short(f : EIFFEL_FORMAT) is
      do
   -- End of alteration
         if not clauses.empty
         then
            f.increase_indent
            from
               clauses.start
	       if not clauses.off_right then
		   f.new_line
		   clauses.item.short(f)
		   clauses.forth
	       end
            until
               clauses.off_right
            loop
	       f.separator
               f.new_line
               clauses.item.short(f)
               clauses.forth
            end
            f.decrease_indent
         end
      end

end -- class EIFFEL_ASSERTION
