-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:28:59 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_assign.e $
	-- Revision 1.3  1993/08/22  12:28:59  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  13:11:09  Neil_Wilson
	-- Added 'defer' feature.
	-- Using different output formatter
	--

class EIFFEL_ASSIGNMENT
-- Expressions

inherit
   EIFFEL_CONSTRUCT      

creation
   parse

feature
   
   left : EIFFEL_TOKEN -- an ID

   right : EIFFEL_EXPRESSION
  
   assignment_op : EIFFEL_TOKEN
 
   parse is
      do
         !!left.parse
         skip
         !!assignment_op.parse
         skip
         !!right.parse
      end -- expression

   defer, short(f : EIFFEL_FORMAT) is
      do
      end

   long (f: EIFFEL_FORMAT) is
   do
   	left.long (f)
	f.space
	assignment_op.long (f)
	f.space
	right.long (f)
   end -- long

   flat(f : EIFFEL_FORMAT) is
      local
         t : EIFFEL_TOKEN
      do
         left.short(f)
         assignment_op.short(f)
         right.short(f)
      end

   copy (other : like Current) is 
      do
         left := clone(other.left)
         right := clone(other.right)
         assignment_op := clone(other.assignment_op)
      end
 
   is_equal(other : like Current): BOOLEAN is
      do
         Result := left.is_equal(other.left) and then
                   right.is_equal(other.right) and then
                   assignment_op.is_equal(other.assignment_op)
      end

end -- class EIFFEL_ASSIGNMENT
