-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel                *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:30:44 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_class.e $
	-- Revision 1.3  1993/08/22  12:30:44  Neil_Wilson
	-- Added 'long' feature.
	-- Class header comment processing is now done.
	--
	-- Revision 1.2  1993/07/18  13:26:48  Neil_Wilson
	-- Addition of 'defer' feature.
	-- Using different output_formatter.
	-- Changed appearance of section to conform
	-- to ETL 'standards' upon output.
	-- Added output manipulator flags.
	--

class EIFFEL_CLASS 
-- The top level of the parsing - A class

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   connect_stream
   
feature

   index : EIFFEL_INDEXING
   class_header : EIFFEL_CLASS_HEADER
   generics : LLIST[EIFFEL_CONSTRAINED_GENERIC]
   obsolete_class : EIFFEL_OBSOLETE
   parents : SLLIST[EIFFEL_PARENT]
   creators : SLLIST[EIFFEL_CREATORS]
   feature_blocks : SLLIST[EIFFEL_FEATURE_BLOCK]
   inv : EIFFEL_ASSERTION
   comment: EIFFEL_TOKEN

   parse is
      local 
         creator : EIFFEL_CREATORS
         featureb : EIFFEL_FEATURE_BLOCK
         parent : EIFFEL_PARENT
         cg : EIFFEL_CONSTRAINED_GENERIC
      do
	 if match(Elex_comment) then
	 	!!comment.parse
		ignore_comments
		consume
	 end
	 ignore_comments
         if match(Elex_indexing)
         then
            !!index.parse
         end
	 if comment = Void then 
		 process_comment
	 end;
         !!class_header.parse
         if match(Elex_lsqbracket)
         then
            consume -- "["
            from
               !!cg.parse
               !!generics.make
               generics.put(cg)
            until
               match(Elex_rsqbracket)
            loop
               matchconsume(Elex_comma)
               !!cg.parse
               generics.put(cg)
            end
            consume -- "]"
         end
         if match(Elex_obsolete)
         then
            !!obsolete_class.parse
         end
         if match(Elex_inherit)
         then
            consume
            from
               !!parents.make
               !!parent.parse
               parents.put(parent)
            until
               match(Elex_creation) or match(Elex_feature) or 
               match(Elex_invariant) or match(Elex_end)
            loop
               !!parent.parse
               parents.put(parent)
               remove_semi
            end
         end
         if match(Elex_creation)
         then
            from
               !!creators.make
            until
               not match(Elex_creation)
            loop
               !!creator.parse
               creators.put(creator)
            end -- loop
         end -- if
         from
            !!feature_blocks.make
         until
            not match(Elex_feature)
         loop
            !!featureb.parse
            feature_blocks.put(featureb)
         end
         accept_comments
         if match(Elex_invariant)
         then
            consume
            !!inv.parse
         end
         ignore_comments
         if match(Elex_comment)
         then
            skip
         end
         if not match(Elex_end)
         then
            error("Missing End")
         else
            consume -- end
         end
         if not eof
         then
            error("End does not finish class")
         end -- if
      end

-- Alteration, Neil Wilson, July 10, 1993
-- Simple flags to alter appearance of short output.

feature -- Output control features

	want_parents: BOOLEAN
		-- Output the parent clause?

	view_name: STRING
		-- Short form is produced for class 'view_name'.

feature {SHORT} -- Option operations.

	set_want_parents (value: like want_parents) is
    	do
		want_parents := value
	end -- set_want_parents

	set_view_name (value: like view_name) is
	require
		proper_name: value /= Void and then not value.empty
	do
		view_name := value
	end -- set_view_name

	-- End of alteration

	-- Alteration, Neil Wilson, July 11, 1993
	-- Addition of defer and change to output formatting

feature -- Output commands

   long (f : EIFFEL_FORMAT) is
   	-- Create fully long class
      do
         if comment /= Void
         then
            comment.long(f)
            f.new_line
	    f.new_line
         end
         if index /= Void
         then
	    f.keyword_write ("indexing");
            index.long (f)
            f.new_line
         end
         class_header.long(f)
         if generics /= Void
         then
            from
               generics.start
	       f.space
               f.normal_write("[")
               generics.item.long(f)
               generics.forth
            until
               generics.off_right
            loop
               f.normal_write(",")
	       f.space
               generics.item.long(f)
               generics.forth
            end
            f.normal_write("]")
         end
         f.new_line
	 if obsolete_class /= Void then
		f.new_line
		obsolete_class.long (f)
		f.new_line
	 end
            if parents /= Void 
            then
	       f.new_line
               f.keyword_write("inherit")
               f.increase_indent
               from
                  parents.start
		  if not parents.off_right then
		      f.new_line
		      parents.item.long(f)
		      parents.forth
		  end
               until
                  parents.off_right
               loop
		  f.separator
		  f.new_line
                  parents.item.long(f)
                  parents.forth
               end -- loop
               f.decrease_indent
               f.new_line
            end -- parent
            if creators /= Void
            then
               from
                  creators.start
               until
                  creators.off_right
               loop
		  creators.item.long(f)
                  creators.forth
               end
            end -- creators
            if feature_blocks /= Void
            then
               from
                  feature_blocks.start
               until
                  feature_blocks.off_right
               loop
		  feature_blocks.item.long(f)
                  feature_blocks.forth
               end
            end -- feature_blocks
            if inv /= Void
            then
               f.new_line
               f.keyword_write("invariant")
               f.new_line
               inv.long(f)
               f.new_line
            end -- inv            
         f.new_line
         f.keyword_write("end")
         f.space
         f.normal_write("-- class")
	 f.space
         f.class_name_write(class_header.name.terminal)
         f.end_output
      end -- long         

   defer (f : EIFFEL_FORMAT) is
   	-- Create fully defer class
      do
         if comment /= Void
         then
            comment.defer(f)
            f.new_line
            f.new_line
         end
         class_header.defer(f)
         if generics /= Void
         then
            from
               generics.start
	       f.space
               f.normal_write("[")
               generics.item.defer(f)
               generics.forth
            until
               generics.off_right
            loop
               f.normal_write(",")
	       f.space
               generics.item.defer(f)
               generics.forth
            end
            f.normal_write("]")
         end
         f.new_line
            if parents /= Void and want_parents
            then
	       f.new_line
               f.keyword_write("inherit")
               f.increase_indent
               from
                  parents.start
		  if not parents.off_right then
		      f.new_line
		      parents.item.long(f)
		      parents.forth
		  end
               until
                  parents.off_right
               loop
		  f.separator
		  f.new_line
                  parents.item.defer(f)
                  parents.forth
               end -- loop
               f.decrease_indent
               f.new_line
            end -- parent
            if feature_blocks /= Void
            then
               from
                  feature_blocks.start
               until
                  feature_blocks.off_right
               loop
		  feature_blocks.item.defer(f)
                  feature_blocks.forth
               end
            end -- feature_blocks
            if inv /= Void
            then
               f.new_line
               f.keyword_write("invariant")
               f.new_line
               inv.defer(f)
               f.new_line
            end -- inv            
         f.new_line
         f.keyword_write("end")
         f.space
         f.normal_write("-- class")
	 f.space
         f.class_name_write(class_header.name.terminal)
         f.end_output
      end -- defer         

   short(f : EIFFEL_FORMAT) is
      do
         if comment /= Void
         then
            comment.short(f)
            f.new_line
            f.new_line
         end
         class_header.short(f)
         if generics /= Void
         then
            from
               generics.start
	       f.space
               f.normal_write("[")
               generics.item.short(f)
               generics.forth
            until
               generics.off_right
            loop
               f.normal_write(",")
	       f.space
               generics.item.short(f)
               generics.forth
            end
            f.normal_write("]")
         end
         f.new_line
         if obsolete_class = Void
         then
            if parents /= Void and want_parents
            then
	       f.new_line
               f.keyword_write("inherit")
               f.increase_indent
               from
                  parents.start
		  if not parents.off_right then
		      f.new_line
		      parents.item.long(f)
		      parents.forth
		  end
               until
                  parents.off_right
               loop
		  f.separator
		  f.new_line
                  parents.item.short(f)
                  parents.forth
               end -- loop
               f.decrease_indent
               f.new_line
            end -- parent
            if creators /= Void
            then
               from
                  creators.start
               until
                  creators.off_right
               loop
		  if creators.item.available_to (view_name) then
			  creators.item.short(f)
		  end
                  creators.forth
               end
            end -- creators
            if feature_blocks /= Void
            then
               from
                  feature_blocks.start
               until
                  feature_blocks.off_right
               loop
		  if feature_blocks.item.available_to (view_name) then
			  feature_blocks.item.short(f)
		  end
                  feature_blocks.forth
               end
            end -- feature_blocks
            if inv /= Void
            then
               f.new_line
               f.keyword_write("invariant")
               f.new_line
               inv.short(f)
               f.new_line
            end -- inv            
         else
	    f.new_line
            obsolete_class.short(f)
         end
         f.new_line
         f.keyword_write("end interface")
         f.space
         f.normal_write("-- class ")
         f.class_name_write(class_header.name.terminal)
         f.end_output
      end -- short         

      -- End of alteration

   has : SLLIST[VERSION]

   normalise is
      do
        from
           !!has.make
           feature_blocks.start
        until
           feature_blocks.off_right
        loop
           feature_blocks.item.normalise
           has.append(feature_blocks.item.normal)
           feature_blocks.forth
        end
      end

   parent_classes : SET[STRING] is
      do
         !!Result
         if parents /= void
         then
            from
               parents.start
            until
               parents.off_right
            loop
               Result.add(parents.item.parent_class)
               parents.forth
            end
         end
      end

   supplier_classes : SET[STRING] is
      do
         from
            !!Result
            feature_blocks.start
         until
            feature_blocks.off_right
         loop
            Result.union(feature_blocks.item.supplier_classes)
            feature_blocks.forth
         end
         if generics /= Void
         then
            from
               generics.start
            until
               generics.off_right            
            loop
               Result.subtract(generics.item.formal_generic.terminal)
               if generics.item.constraint /= Void
               then
                  Result.add(generics.item.constraint.terminal)
               end -- if
               generics.forth
            end -- loop
         end -- if
      end

   connect_parents(ancestors : GRAPH[STRING]) is
      require
         ancestors /= Void
      local
         cn : STRING
      do
         cn := clone(class_header.name.terminal)
         if equal(cn,"any") 
         then
            ancestors.remove_edge("any","any")
         elseif equal(cn,"none")
         then
            ancestors.remove_edge("none","any")
            ancestors.remove_edge("none","none")
         elseif equal(cn,"platform")
         then
            ancestors.remove_edge("platform","any")
            ancestors.remove_edge("none","platform")
            ancestors.add_edge("any","platform")
         elseif equal(cn,"general")
         then
            ancestors.remove_edge("general","any")
            ancestors.remove_edge("none","general")
            ancestors.add_edge("platform","general")
         elseif parents /= Void
         then
            ancestors.remove_edge(cn,"any")
            from
               parents.start
            until
               parents.off_right
            loop
               ancestors.add_edge(cn,parents.item.parent_class)
               debug
                  io.putstring(parents.item.parent_class)
                  io.new_line
               end
               ancestors.remove_edge("none",parents.item.parent_class)
               parents.forth
            end -- loop
         end -- if
      end -- routine

   connect_suppliers(suppliers : GRAPH[STRING]) is
      require
         suppliers /= Void
      local
         cn : STRING
         supp : SET[STRING]
      do
         cn := clone(class_header.name.terminal)
         debug
            io.putstring(cn)
            io.putstring(" being connected%N")
         end
         supp := supplier_classes
         if supp /= Void and then not supp.empty
         then
            from
               supp.start
            until
               supp.finished
            loop
               suppliers.add_edge(cn,supp.item)
               supp.forth
            end -- loop
         end -- if
      end -- routine

   flat(f : EIFFEL_FORMAT) is
      require else
         has /= Void
      do
         if comment /= Void
         then
            comment.flat(f)
            f.new_line
         end
         if index /= Void
         then
            index.flat(f)
            f.new_line
         end
         class_header.flat(f)
         if generics /= Void
         then
            from
               generics.start
	       f.space
               f.normal_write("[")
               generics.item.flat(f)
               generics.forth
            until
               generics.off_right
            loop
               f.normal_write(",")
	       f.space
               generics.item.flat(f)
               generics.forth
            end
            f.normal_write("]")
         end
         f.new_line
         f.new_line
         if obsolete_class = Void
         then
            if creators /= Void
            then
               from
                  creators.start
               until
                  creators.off_right
               loop
                  creators.item.flat(f)
                  creators.forth
                  f.new_line
               end
            end -- creators
            from
               has.start
            until
               has.off_right
            loop
               has.item.flat(f)
               has.forth
            end
            if inv /= Void
            then
               f.new_line
               f.keyword_write("invariant")
               f.new_line
               inv.flat(f)
               f.new_line
            end -- inv            
         else
            obsolete_class.flat(f)
         end
         f.new_line
         f.keyword_write("end")
         f.space
         f.normal_write("-- class ")
         class_header.name.flat(f)         
         f.end_output
      end -- flat         
      
   is_equal(other : like Current) : BOOLEAN is
      do
         Result := equal(index,other.index) and then
                   class_header.is_equal(other.class_header) and then
                   equal(generics,other.generics) and then
                   equal(obsolete_class,other.obsolete_class) and then
                   equal(parents,other.parents) and then
                   equal(creators,other.creators) and then
                   equal(feature_blocks, other.feature_blocks) and then
                   equal(inv,other.inv) and then
                   equal(has,other.has) and then equal (comment, other.comment)
      end

   copy(other : like Current) is
      do
         index := clone(other.index)
         class_header := clone(other.class_header)
         generics := clone(other.generics)
         obsolete_class := clone(other.obsolete_class)
         parents := clone(other.parents)
         creators := clone(other.creators)
         feature_blocks := clone(other.feature_blocks)
         inv := clone(other.inv)
         has := clone(other.has)
	 comment := clone (other.comment)
      end

feature {NONE}

   process_comment is
      do
         mark
	 l.collect_to_end_of_line
	 accept_comments
         consume
	 ignore_comments
         if match(Elex_comment)
         then
            !!comment.parse
         end
         return
      end

end -- class EIFFEL_CLASS
