-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:32:52 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_clause.e $
	-- Revision 1.3  1993/08/22  12:32:52  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CLAUSE
-- A clause from an assertion 
-- This will be a single comment or expression, either with a possible tag

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse

feature

   name : EIFFEL_TOKEN

   expr : EIFFEL_EXPRESSION

   comment : EIFFEL_TOKEN

   parse is
      local 
         lname : EIFFEL_TOKEN
      do
         if match(Elex_id)
         then
            mark
            !!lname.parse
            skip
            if match(Elex_colon)
            then
               name := lname
               consume
            else
               return
            end
         end
         if match(Elex_comment)
         then
            !!comment.parse
            skip
         else
            debug
                io.putstring("Call from clause%N")
            end
            !!expr.parse
         end -- if
      end

   long, defer, flat, short(f : EIFFEL_FORMAT) is
      do
         if name /= Void
         then
            name.short(f)
            f.normal_write(":")
            f.space
         end
         if expr /= Void
         then
            expr.short(f)
         else
            comment.short(f)
         end
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := equal(name,other.name) and then
                   equal(expr,other.expr) and then
                   equal(comment,other.comment)
      end

   copy(other : like Current) is
      do
        name := clone(other.name)
        expr := clone(other.expr)
        comment := clone(other.comment)
      end

end -- class EIFFEL_CLAUSE
