-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:33:13 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_client.e $
	-- Revision 1.3  1993/08/22  12:33:13  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CLIENTS
-- A clients expression

inherit
   EIFFEL_CONSTRUCT
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature 

   clients : EIFFEL_SORTED_ID_LIST

   parse is
      do
         matchconsume(Elex_lbrace)
         !!clients.parse
         matchconsume(Elex_rbrace)
      end

   contains(s : STRING) : BOOLEAN is
      do
         Result := clients.contains(s)
      end

   contains_none : BOOLEAN is
      do
         Result := clients.values.empty or else
                   (clients.contains("none") and clients.values.count = 1)
      end

   long, defer, flat, short(f : EIFFEL_FORMAT) is
      do
         f.normal_write("{")
         clients.upshort(f)
         f.normal_write("}")
      end
 
   infix "<" (other : like Current) : BOOLEAN is
      do
         Result := clients < other.clients    
      end


   copy ( other : like Current) is
      do
         clients := clone(other.clients)
      end

   is_equal (other : like Current) : BOOLEAN is
      do
         Result := clients.is_equal(other.clients)
      end
 
end -- class EIFFEL_CLIENTS
