-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:34:27 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_condcp.e $
	-- Revision 1.3  1993/08/22  12:34:27  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CONDITIONAL_COMPOUND
-- A compound with a condition attached

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   condition : EIFFEL_EXPRESSION
   
   compound : EIFFEL_COMPOUND
   
   parse is
      local
         t : EIFFEL_CONSTRUCT
      do
         !!condition.parse -- boolean
         matchconsume(Elex_then)
         !!compound.parse
      end -- parse

   defer, short(f : EIFFEL_FORMAT) is
      do
      end
      
   flat, long(f : EIFFEL_FORMAT) is
      do
         condition.long(f)
         f.space
         f.keyword_write("then")
         compound.long(f)
      end
      
   is_equal(other : like Current) : BOOLEAN is
      do
         Result := condition.is_equal(other.condition) and then
                   compound.is_equal(other.compound)
      end

   copy(other : like Current) is
      do
         condition := clone(other.condition)
         compound  := clone(other.compound)
      end

end -- class EIFFEL_CONDITIONAL_COMPOUND         
