-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:35:14 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_constr.e $
	-- Revision 1.3  1993/08/22  12:35:14  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

deferred class EIFFEL_CONSTRUCT
-- a class for parsing eiffel constructs

inherit
   LEXICAL_EIFFEL_CONSTANT
      undefine
         copy,
         is_equal
      end
   CONSTRUCT
      undefine
         copy,
         is_equal
      redefine
         l
      end
   ANY
      undefine
         copy,
         is_equal
      end

feature

   l : LEX_EIFFEL is
      once
         !!Result.make
      end

   long, defer, flat, short (f : EIFFEL_FORMAT) is
      deferred
      end

   remove_semi is
      do
         from
         until
            not match(Elex_semi)
         loop
            consume
         end
      end

end -- class EIFFEL_CONSTRUCT

