-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:35:41 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_creatn.e $
	-- Revision 1.3  1993/08/22  12:35:41  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_CREATION
-- A creation instruction

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   dynamic_type : EIFFEL_TYPE

   created_entity : EIFFEL_TOKEN
   
   creation_feature : EIFFEL_UNQUALIFIED_CALL
   
   parse is
      do
         matchconsume(Elex_bang)
         if not match(Elex_bang)
         then
            !!dynamic_type.parse
         end -- if
         matchconsume(Elex_bang)
         if match(Elex_id) or match(Elex_result)
         then
            !!created_entity.parse
            consume -- ID
         end
         if match(Elex_dot)
         then
            consume
            !!creation_feature.parse
         end -- if
      end -- parse   

   flat, long(f : EIFFEL_FORMAT) is
      do
         f.normal_write("!")
         if dynamic_type /= Void
         then
            dynamic_type.long(f)
         end -- if
         f.normal_write("!")
         created_entity.long(f)
         if creation_feature /= Void
         then
            f.normal_write(".")
            creation_feature.long(f)
         end
      end

   defer, short(f : EIFFEL_FORMAT) is
      do
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := created_entity.is_equal(other.created_entity) and then
                   equal(dynamic_type, other.dynamic_type) and then 
                   equal(creation_feature, other.creation_feature)
      end

   copy(other : like Current) is
      do
         created_entity := clone(other.created_entity)
         dynamic_type := clone(other.dynamic_type)
         creation_feature := clone(other.creation_feature)
      end

end -- class EIFFEL_CREATION
