-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:36:10 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_creats.e $
	-- Revision 1.3  1993/08/22  12:36:10  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  13:38:41  Neil_Wilson
	-- Added 'defer' feature.
	-- Using different output formatter
	-- Separated 'short' and 'flat' features to make
	-- short output conform to ETL 'standards'.
	-- Added feature 'available_to', used by shortener.
	--

class EIFFEL_CREATORS

inherit
   EIFFEL_CONSTRUCT
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   clients : EIFFEL_CLIENTS
   
   creation_features : EIFFEL_SORTED_ID_LIST

   parse is
      do
         matchconsume(elex_creation)
         if not match(Elex_feature) and not match(Elex_end)
         then
            if match(Elex_lbrace)
            then
               !!clients.parse
            end
            !!creation_features.parse
         end -- if
      end -- creators

  -- Alteration, Neil Wilson, July 11, 1993
  -- Added defer clause, flat separate feature

   defer (f : EIFFEL_FORMAT) is
   	-- deferred classes have no creation section
      do
      end


   long, flat (f : EIFFEL_FORMAT) is
      do
         f.new_line
         f.keyword_write("creation")
         f.space
         if clients /= Void
         then
            clients.long(f)
         else
	    debug
		f.normal_write("{")
		f.class_name_write("ANY")
		f.normal_write("}")
	    end
         end
         f.increase_indent
         f.new_line
         if creation_features /= Void
         then
	    f.new_line
            creation_features.long(f)
	    f.new_line
         end
         f.decrease_indent
      end -- long
  

   short(f : EIFFEL_FORMAT) is
      do
         f.new_line
         f.keyword_write("creation procedures")
         f.space
         if clients /= Void
         then
            clients.short(f)
         else
	    debug
		f.normal_write("{")
		f.class_name_write("ANY")
		f.normal_write("}")
	    end
         end
         f.increase_indent
         f.new_line
         if creation_features /= Void
         then
	    f.new_line
            creation_features.short(f)
	    f.new_line
         end
         f.decrease_indent
      end
  
  -- End of alteration

  -- Alteration, Neil Wilson, Jully 10, 1993
  -- Added feature available_to

   available_to (class_name : STRING): BOOLEAN is
   	-- Is this creation block exported to class_name ?
   require
   	class_name_available: class_name /= Void and then not class_name.empty
   do
   	class_name.to_lower;
   	Result := equal (class_name, "none") -- 'See all' class
		or clients = Void -- Publicly available 
		or else clients.contains ("any") -- Parent of all classes
		or else clients.contains (class_name);
   end -- available_to

   -- End of alteration

   infix "<" (other : like Current) : BOOLEAN is
      do
         Result := (clients /= Void and then 
                    other.clients /= Void and then 
                    clients < other.clients) 
                   or 
                    clients = Void 
      end

   is_equal(other : like Current) : BOOLEAN is
      do
         Result := equal(clients,other.clients) and then
                   equal(creation_features,other.creation_features)
      end

   copy(other : like Current) is
      do
         clients := clone(other.clients)
         creation_features := clone(other.creation_features)
      end

end -- class EIFFEL_CREATORS
