-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:38:11 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_expr.e $
	-- Revision 1.3  1993/08/22  12:38:11  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_EXPRESSION
-- Expressions

inherit
   EIFFEL_CONSTRUCT      
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse

creation {EIFFEL_CONSTRUCT}
   make
   
feature
   
   left, right : EIFFEL_CONSTRUCT
   
   label : EIFFEL_CONSTRUCT
   
   make(token : EIFFEL_TOKEN; lt,rt : EIFFEL_CONSTRUCT) is
       do 
          left := lt
          right := rt
          label := token
       end

   parse is
      local
         lastor, 
         lastand : BOOLEAN
         operand : EIFFEL_TERM
         operator : EIFFEL_TOKEN
      do
         debug
            io.putstring("e_expr parse called%N")
         end
         from
            !!operators.make
            !!operands.make
            process_unary
            !!operand.parse
            operands.put(operand)
         until
            not match(Elex_dot) and not match(Elex_plus) and 
            not match(Elex_minus) and not match(elex_divide) and
            not match(Elex_star) and not match(Elex_nequal) and
            not match(Elex_equal) and not match(Elex_lessthan) and
            not match(Elex_greaterthan) and not match(Elex_lessequal) and 
            not match(Elex_greatequal) and not match(Elex_div) and
            not match(Elex_mod) and not match(Elex_caret) and 
            not match(Elex_xor) and not match(Elex_and) and 
            not match(Elex_or) and not match(Elex_implies)
            and not match(Elex_free)
         loop
            lastor := match(Elex_or)
            lastand := match(Elex_and)
            !!operator.parse
            consume
            if lastor and match(Elex_else)
            then
               operator.terminal.append(" else")
               operator.reset_type(Elex_orelse)
               consume
            end -- if
            if lastand and match(Elex_then)
            then
               operator.terminal.append(" then")
               operator.reset_type(Elex_andthen)
               consume
            end -- if
            operators.put(operator)
            process_unary
            !!operand.parse
            operands.put(operand)
         end -- loop
         precedence
         debug
            io.putstring("After precedence%N")
         end
         if operators.count > 0
         then -- binary expression
            label := operators.nth(1)
            left := operands.nth(1)
            right := operands.nth(2)
         else -- unary
            label := operands.nth(1)
         end -- if
      end -- expression

   long, defer, flat,short(f : EIFFEL_FORMAT) is
      local
         t : EIFFEL_TOKEN
      do
         if left /= Void
         then
            left.short(f)
         end
         t ?= label
         if t /= Void 
         then
            if equal(t.terminal,".") 
            then
               f.normal_write(t.terminal)
            elseif equal(t.terminal,"not") or equal(t.terminal,"old") 
                or equal(t.terminal,"strip")
            then
               f.keyword_write(t.terminal)
               f.space
            else
               f.space
               f.normal_write(t.terminal)
               f.space
            end
         else
            label.short(f)
         end -- if
         if right /= Void
         then
            right.short(f)
         end         
      end

feature {NONE}

   operators : DLLIST[EIFFEL_TOKEN]

   operands : DLLIST[EIFFEL_CONSTRUCT]

   precedence is
       do
          debug
             io.putstring("in precedence")
          end
          binary_associate(<<Elex_dot>>)
          unary_associate(<<Elex_old,Elex_not,Elex_plus,Elex_minus,Elex_free>>)
          binary_associate(<<Elex_free>>)
          binary_associate(<<Elex_caret>>)
          binary_associate(<<Elex_star,Elex_divide,Elex_div,Elex_mod>>)
          binary_associate(<<Elex_plus,Elex_minus>>)
          binary_associate(<<Elex_equal,Elex_nequal,Elex_lessthan,Elex_greaterthan
                           ,Elex_greatequal,Elex_lessequal>>)
          binary_associate(<<Elex_and,Elex_andthen>>)
          binary_associate(<<Elex_or,Elex_orelse,Elex_xor>>)
          binary_associate(<<Elex_implies>>)
          debug
             io.putstring("end precedence")
          end
       end

   binary_associate(opers : ARRAY[iNTEGER]) is
      local
         tf : ASCII_FORMAT
         t : EIFFEL_CONSTRUCT
         expr : EIFFEL_EXPRESSION
      do
         from
            operators.start
            operands.start
         until
            operators.count <= 1 or operators.off_right
         loop
            if contains(opers,operators.item.type)
            then
               -- get one branch in operands.item the other in t
               operands.mark
               operands.forth
               t := operands.item
               operands.return
               -- replace the left operand by the new tree
               !!expr.make(operators.item,operands.item,t)
               operands.replace(expr)
               -- get rid of the extra argument
               operands.mark
               operands.forth
               operands.remove
               operands.return
               -- get rid of the operator
               operators.forth -- past current one
               if operators.off_right -- no more anyway
               then
                  operators.finish
                  operators.remove
                  operators.forth
               else
                  operators.mark -- remember so we can go back to it
                  operators.back -- delete the operator
                  operators.remove
                  operators.return -- go back
               end -- if
            else
               operators.forth   
               operands.forth
            end -- if
         end -- loop
         debug
            from
               io.putint(operands.count)
               io.putchar(':')
               io.putint(operators.count)
               io.putstring("End binary associate : ")            
               !!tf.make(3)
               operators.start
               operands.start
               if operands.item /= Void
               then
                  operands.item.short(tf)
               end
               operands.forth
            until
               operators.off_right
            loop
               operators.item.short(tf)
               if operands.item /= Void
               then
                  operands.item.short(tf)
               end
               operators.forth
               operands.forth
            end
            io.new_line
         end -- debug
      end

   unary_associate(opers : ARRAY[INTEGER]) is
      local
         tf : ASCII_FORMAT
         t : EIFFEL_CONSTRUCT
         expr : EIFFEL_EXPRESSION
      do
         from
            operators.finish
            operands.finish
            operands.back
         until
            operators.count = 0 or operators.off_left
         loop
            if contains(opers,operators.item.type) and 
               operands.item = Void
            then
               -- get empty branch in operands.item the other in t
               operands.forth
               t := operands.item
               operands.back
               -- replace the left operand by the new tree
               !!expr.make(operators.item,Void,t)
               operands.replace(expr)
               -- get rid of the extra argument
               operands.mark
               operands.forth
               operands.remove
               operands.return 
               -- move to the next appropriate place
               operands.back
               -- get rid of the operator
               operators.back -- past current one
               operators.mark -- remember so we can go back to it
               if operators.off_left -- no more to the left anyway
               then
                  debug
                     io.putstring("Off left%N")
                  end
                  operators.start
               else
                  operators.forth -- delete the operator
               end
               operators.remove
               operators.return -- go back
               debug
                  if operators.off_left
                  then
                     io.putstring("Off left%N")
                  end
               end
            else
               operators.back
               operands.back
            end -- if
         end -- loop
         debug
            from
               io.putstring("End unary associate : ")            
               !!tf.make(3)
               operators.start
               operands.start
               operands.item.short(tf)
               operands.forth
            until
               operators.off_right
            loop
               operators.item.short(tf)
               operands.item.short(tf)
               operators.forth
               operands.forth
            end
            io.new_line
         end -- debug
      end

   contains(ar : ARRAY[INTEGER]; s : INTEGER): BOOLEAN is
      local
         i : INTEGER
      do
         debug
            io.putstring("Contains ")
            io.putint(s)
            io.new_line
         end
         from
            i := ar.lower
         until
            i > ar.upper or Result
         loop
            Result := s = ar.item(i)
            i := i + 1
         end
      end

   process_unary is 
      local
         t : EIFFEL_TOKEN
      do
        from
        until
           not match(Elex_not) and not match(Elex_minus) and
           not match(Elex_plus) and not match(Elex_free) and 
           not match(Elex_old) 
        loop
           !!t.parse
           operators.put(t)
           operands.put(Void)
           consume
        end -- loop   
      end -- process_unary
      
feature {ANY}

   copy(other : like Current) is
      do
         left := clone(other.left)
         label := clone(other.label)
         right := clone(other.right)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(left,other.left) and then
                   equal(label,other.label) and then
                   equal(right,other.right)
      end
      
end -- class EIFFEL_EXPRESSION
