-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:38:42 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_extern.e $
	-- Revision 1.3  1993/08/22  12:38:42  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_EXTERNAL
-- An external feature

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature
   external_name, alias_name : EIFFEL_TOKEN
   
   parse is
      do
         matchconsume(Elex_external)
         !!external_name.parse
         matchconsume(Elex_string)
         if match(Elex_alias)
         then
            consume
            !!alias_name.parse
            matchconsume(Elex_string)
         end -- if
      end

   defer, short(f : EIFFEL_FORMAT) is
      do
      end -- short
      
   long, flat(f : EIFFEL_FORMAT) is
      do
         f.keyword_write("external")
         f.increase_indent
         f.new_line
         external_name.long(f)
         f.decrease_indent
         f.new_line
         if alias_name /= Void
         then
            f.keyword_write("alias")
            f.increase_indent
            f.new_line
            alias_name.long(f)
            f.decrease_indent
         end
      end
      
   copy(other : like Current) is
      do
         external_name := clone(other.external_name)
         alias_name := clone(other.alias_name)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(external_name,other.external_name) and then
                   equal(alias_name,other.alias_name)
      end
      
end -- class EIFFEL_EXTERNAL
