-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: E_IF.E $
	-- Revision 1.3  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_IF

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   conditionals : LLIST[EIFFEL_CONDITIONAL_COMPOUND]
   
   else_part : EIFFEL_COMPOUND
   
   parse is
      local
         t : EIFFEL_CONDITIONAL_COMPOUND
      do
         !!conditionals.make
         matchconsume(Elex_if)
         from
            !!t.parse
            conditionals.put(t)
         until
            match(Elex_else) or match(Elex_end)
         loop
            matchconsume(Elex_elseif)
            !!t.parse
            conditionals.put(t)
         end -- loop
         if match(Elex_else)
         then
            consume
            !!else_part.parse
         end
         matchconsume(Elex_end)
      end -- parse

   defer, short(f : EIFFEL_FORMAT) is
      do
      end -- short
      
   flat, long(f : EIFFEL_FORMAT) is
      do
         f.keyword_write("if")
         f.space
         from
            conditionals.start
            conditionals.item.long(f)
            conditionals.forth
         until
            conditionals.off_right
         loop
            f.new_line
            f.keyword_write("elseif")
            f.space
            conditionals.item.long(f)
            conditionals.forth
         end
         if else_part /= Void
         then
            f.new_line
            f.keyword_write("else")
            else_part.long(f)
         end
         f.new_line
         f.keyword_write("end")
      end
      
   copy(other : like Current) is
      do
         conditionals := clone(other.conditionals)
         else_part := clone(other.else_part)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(conditionals,other.conditionals) and then
            equal(else_part,other.else_part)
      end
      
end -- class EIFFEL_IF         
