-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: E_LOOP.E $
	-- Revision 1.3  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_LOOP
-- The loop construct

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   init,body : EIFFEL_COMPOUND
   inv       : EIFFEL_ASSERTION
   var,termination  : EIFFEL_EXPRESSION
   
   parse is
      do
         consume -- from
         !!init.parse
         accept_comments
         if match(Elex_invariant)
         then
            consume
            !!inv.parse
         end
         ignore_comments
         if match(Elex_comment)
         then
            skip
         end -- if
         if match(Elex_variant)
         then
            consume
            mark
            if match(Elex_id)
            then
               matchconsume(Elex_id)
               if not match(elex_colon)
               then
                  return
               else
                  consume
               end
            end
            !!var.parse
         end
         matchconsume(Elex_until)
         !!termination.parse -- boolean
         matchconsume(Elex_loop)
         !!body.parse
         matchconsume(Elex_end)
      end -- parse

      
   defer, short(f : EIFFEL_FORMAT) is
      do
      end -- short
      
   long, flat(f : EIFFEL_FORMAT) is
      do
         f.keyword_write("from")
         init.long(f)
         f.new_line
         if inv /= Void
         then
            f.keyword_write("invariant")
            inv.long(f)
            f.new_line
         end
         if var /= Void
         then
            f.keyword_write("variant")
            f.increase_indent
            f.new_line
            var.long(f)
            f.decrease_indent
            f.new_line
         end
         f.keyword_write("until")
         f.increase_indent
         f.new_line
         termination.long(f)
         f.decrease_indent
         f.new_line
         f.keyword_write("loop")
         body.long(f)
         f.new_line
         f.keyword_write("end")
      end
      
   copy(other : like Current) is
      do
         init := clone(other.init)
         body := clone(other.body)
         inv := clone(other.inv)
         var := clone(other.var)
         termination := clone(other.termination)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(init,other.init) and then
            equal(body, other.body) and then 
            equal(inv, other.inv) and then
            equal(var, other.var) and then
            equal(termination, other.termination)
      end
      
end -- class EIFFEL_LOOP      
