-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: E_MANARR.E $
	-- Revision 1.3  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_MANIFEST_ARRAY
-- A manifest array in the class text

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse

feature

   args : LLIST[EIFFEL_EXPRESSION]

   parse is
      local
         t : EIFFEL_EXPRESSION
      do 
         !!args.make
         matchconsume(Elex_lmanarr)
         from
            !!t.parse
            args.put(t)
         until
            not match(Elex_comma)
         loop
            consume -- ,
            !!t.parse
            args.put(t)
         end
         matchconsume(Elex_rmanarr)
      end -- parse

   long, defer, flat,short(f : EIFFEL_FORMAT) is
      do
         from 
            f.normal_write("<<")
            args.start
            args.item.flat(f)
            args.forth
         until
            args.off_right
         loop
            f.normal_write(",")
	    f.space
            args.item.flat(f)
            args.forth
         end
         f.normal_write(">>")
      end
      
   copy(other : like Current) is
      do
         args := clone(other.args)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(args,other.args)
      end
      
end -- MANIFEST_ARRAY
