-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.4 $";
	author: "David_Morgan";
	log: 
	-- $Log: E_PARENT.E $
	-- Revision 1.4  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.3  1993/08/01  09:49:42  David_Morgan
	-- Added semi-colon support for parents
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_PARENT
-- A parent of a class

inherit
   EIFFEL_CONSTRUCT
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   parent : EIFFEL_CLASS_TYPE
   renames : EIFFEL_RENAME
   exports : EIFFEL_NEW_EXPORTS
   undefines, redefines, selects : EIFFEL_NEW_FEATURE_LIST

   parent_class : STRING is
      do
         Result := clone(parent.base_class.terminal)
      end

   parse is
      local
         want_end : BOOLEAN
         t : EIFFEL_TOKEN
      do
         !!parent.parse
         if match(Elex_rename) 
         then
            consume
            !!renames.parse
            want_end := true
         end
         if match(Elex_export) 
         then
            consume
            !!exports.parse
            want_end := true
         end
         if match(Elex_undefine) 
         then
            consume
            !!undefines.parse
            want_end := true
         end
         if match(Elex_redefine) 
         then
            consume
            !!redefines.parse
            want_end := true
            end
         if match(Elex_select) 
         then
            consume
            !!selects.parse
            want_end := true
         end
         if want_end or match(Elex_end)
         then
            matchconsume(Elex_end)
         end   
	 remove_semi
      end -- Parent

   long, defer, short(f : EIFFEL_FORMAT) is
      do
         f.new_line
         parent.short(f)
         f.increase_indent
         sub_short(f,"rename",renames)
         sub_short(f,"export",exports)
         sub_short(f,"undefine",undefines)
         sub_short(f,"redefine",redefines)
         sub_short(f,"select",selects)
         if renames /= Void or else
            exports /= Void or else
            undefines /= Void or else
            redefines /= Void or else
            selects /= Void
         then
            f.new_line
            f.keyword_write("end")
         end
         f.decrease_indent
      end

   sub_short(f : EIFFEL_FORMAT; s : STRING; c : EIFFEL_CONSTRUCT) is
      do
         if c /= Void
         then
            f.new_line
            f.keyword_write(s)
            f.increase_indent
            f.new_line
            c.short(f)
            f.decrease_indent
         end -- if
      end -- sub_short

   infix "<" (other : like Current) : BOOLEAN is
      do
         Result := parent < other.parent 
      end

   supplier_classes : SET[STRING] is
      do
         Result := parent.supplier_classes
         Result.start
         Result.subtract(result.item) -- remove the 1st item
      end
      
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         parent := clone(other.parent)
         renames := clone(other.renames)
         exports := clone(other.exports)
         redefines := clone(other.redefines)
         undefines := clone(other.undefines)
         selects := clone(other.selects)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(parent,other.parent) and then
            equal(renames, other.renames) and then
            equal(exports, other.exports) and then
            equal(redefines, other.redefines) and then
            equal(undefines, other.undefines) and then
            equal(selects, other.selects)
      end
      
end -- class EIFFEL_INHERIT
