-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.4 $";
	author: "David Morgan";
	log: 
	-- $Log: E_ROUTIN.E $
	-- Revision 1.4  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.3  1993/08/01  09:45:03  David_Morgan
	-- Added semicolon support in 'local' clause
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_ROUTINE
-- A routine construct

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   obs : EIFFEL_OBSOLETE
   -- obsolete clause

   pre, post : EIFFEL_ASSERTION
   -- pre and post condition

   locals : LLIST[EIFFEL_ENTITY_DECLARATION]
   -- local declarations

   body : EIFFEL_CONSTRUCT
   -- body of declaration

   resc : EIFFEL_COMPOUND
   -- rescue clause

   inherited,once_function, normal_feature : BOOLEAN
   -- other details

   parse is
   -- parsing routine
      local
         ed : EIFFEL_ENTITY_DECLARATION
      do
         if match(Elex_obsolete)
         then
            !!obs.parse
         end
         if match(Elex_require)
         then
            accept_comments
            consume
            if match(Elex_else)
            then
               consume
               inherited := true
            end
            !!pre.parse
            ignore_comments
         end -- if
         if match(Elex_local)
         then
            consume
            from
               !!locals.make
            until
               match(Elex_do) or match(Elex_once)
            loop
               !!ed.parse
               locals.put(ed)
               remove_semi 
            end
         end
         if match(Elex_do)
         then
            consume
	    normal_feature := true
            !EIFFEL_COMPOUND!body.parse
         elseif match(Elex_once)
         then
            consume
            once_function := true
            !EIFFEL_COMPOUND!body.parse
         elseif match(Elex_deferred)
         then
            !EIFFEL_TOKEN!body.parse
            consume
         else
            !EIFFEL_EXTERNAL!body.parse
         end
         if match(Elex_ensure)
         then
            accept_comments
            consume
            if match(Elex_then) or else inherited
            then
               matchconsume(Elex_then)
               inherited := true
            end
            !!post.parse
            ignore_comments
         end
         if match(Elex_rescue)
         then
            consume
            !!resc.parse
         end
         matchconsume(Elex_end)
      end -- routine

   defer (f : EIFFEL_FORMAT) is
   -- display the relevant details of this class
      local
         t : EIFFEL_TOKEN
      do
           if pre /= Void
           then
              f.indent
              f.new_line
              f.keyword_write("require")
              pre.defer(f)
              f.decrease_indent
           end -- if
           f.indent
           f.new_line
           f.keyword_write ("deferred")
           f.decrease_indent
           if post /= Void
           then
              f.indent
              f.new_line
              f.keyword_write("ensure")
              post.defer(f)
              f.decrease_indent
           end -- if
     end -- defer

   short(f : EIFFEL_FORMAT) is
   -- display the relevant details of this class
      local
         t : EIFFEL_TOKEN
      do
        if obs /= Void
        then 
           obs.short(f)
        else
           if pre /= Void
           then
              f.indent
              f.new_line
              f.keyword_write("require")
              if inherited
              then
                 f.space
                 f.keyword_write("else")           
              end
              pre.short(f)
              f.decrease_indent
           end -- if
           t ?= body
           if t /= Void
           then
              f.indent
              f.new_line
              body.short(f)
              f.decrease_indent
           end
           if post /= Void
           then
              f.indent
              f.new_line
              f.keyword_write("ensure")
              if inherited
              then
                 f.space
                 f.keyword_write("then")
              end
              post.short(f)
              f.decrease_indent
           end -- if
        end -- if obsolete
     end -- if

   supplier_classes: SET[STRING] is
      do
         !!Result
         if locals /= Void and then not locals.empty
         then
            from
               locals.start            
            until
               locals.off_right
            loop
               Result.union(locals.item.supplier_classes)
               locals.forth
            end -- loop
         end -- if
      end -- supplier classes
 
   long, flat(f : EIFFEL_FORMAT) is
      do
         if obs /= Void
         then 
	    f.increase_indent
	    f.increase_indent
	    f.new_line
            obs.long(f)
	    f.decrease_indent
	    f.decrease_indent
	 end
            if pre /= Void
            then
               f.indent
               f.new_line
               f.keyword_write("require")
               if inherited
               then
                  f.space
                  f.keyword_write("else")           
               end
               pre.long(f)
               f.decrease_indent
            end -- if
	    if locals /= Void then
	    	f.indent
		f.new_line
		f.keyword_write ("local")
		f.increase_indent
		from
		    locals.start
		    if not locals.off_right then
			f.new_line
			locals.item.long (f)
			locals.forth
		    end
		until
			locals.off_right
		loop
			f.separator
			f.new_line
			locals.item.long (f)
			locals.forth
		end
		f.decrease_indent
		f.decrease_indent
	    end
            f.indent
	    f.new_line
            if once_function then
               f.keyword_write("once")
	    elseif normal_feature then
	       f.keyword_write ("do")
	    end
            body.long(f)
	    f.decrease_indent
            if post /= Void
            then
               f.indent
               f.new_line
               f.keyword_write("ensure")
               if inherited
               then
                  f.space
                  f.keyword_write("then")
               end
               post.long(f)
               f.decrease_indent
            end -- if
	    if resc /= Void then
	    	f.indent
		f.new_line
		f.keyword_write ("rescue");
		resc.long (f)
		f.decrease_indent
	    end
      end
      
   copy(other : like Current) is
      do
         obs := clone(other.obs)
         pre := clone(other.pre)
         post := clone(other.post)
         locals := clone(other.locals)
         body := clone(other.body)
         resc := clone(other.resc)
         once_function := other.once_function
         inherited := other.inherited
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(obs,other.obs) and then
            equal(pre, other.pre) and then
            equal(post, other.post) and then
            equal(locals, other.locals) and then
            equal(body, other.body) and then
            equal(resc, other.resc) and then
            once_function = other.once_function and then
            inherited = other.inherited
      end
      
end -- class EIFFEL_ROUTINE
