-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: E_SIDLST.E $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_SORTED_ID_LIST

inherit
   COMPARABLE
      rename
         copy as comp_copy,
         is_equal as comp_is_equal
      end
   EIFFEL_ID_LIST
      redefine
         copy,
         is_equal,
         values
      select
         copy, is_equal
      end

creation
   parse

feature

   values : SLLIST[EIFFEL_TOKEN]

   infix "<" (other : like Current) : BOOLEAN is
      do
         from
            Result := true
            values.start
            other.values.start
         until
            not Result or else
            other.values.off_right or else
            values.off_right
         loop
            Result := values.item < other.values.item
            debug
               io.putstring(values.item.terminal)
               io.putstring(" + ")
               io.putstring(other.values.item.terminal)
               io.new_line
            end
            values.forth
            other.values.forth
         end  -- loop
         Result := Result and values.off_right and not other.values.off_right
      end

   is_equal(other : like Current) : BOOLEAN is
      do
        Result := values.is_equal(other.values)
      end

   copy(other : like Current) is 
      do
         values := clone(other.values)
      end

end -- class EIFFEL_SORTED_ID_LIST
