-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: E_TERM.E $
	-- Revision 1.3  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_TERM
-- A single term

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   value : EIFFEL_CONSTRUCT
 
   parse is
      local
         e : EIFFEL_EXPRESSION
         stript : EIFFEL_TOKEN
         strip_list : EIFFEL_ID_LIST
      do
         if match(Elex_strip)
         then
            !!stript.parse
            consume
            matchconsume(Elex_lbracket)
            !!strip_list.parse
            matchconsume(Elex_rbracket)
            !!e.make(stript,Void,strip_list)
            value := e
         elseif match(Elex_lbracket)
         then
            consume -- (
            if not match(Elex_rbracket)
            then
               !EIFFEL_EXPRESSION!value.parse
            end
            matchconsume(Elex_rbracket)
         elseif match(Elex_true) or match(Elex_false) or
            match(Elex_int) or match(Elex_real) or
            match(Elex_char) or match(Elex_string) or match(Elex_bitseq)  
         then
            !EIFFEL_MANIFEST_CONSTANT!value.parse
         elseif match(Elex_lmanarr)
         then
            !EIFFEL_MANIFEST_ARRAY!value.parse
         elseif match(Elex_id) or match(Elex_result) or match(Elex_current)
         then
            !EIFFEL_UNQUALIFIED_CALL!value.parse
         else
            error("Unable to process term")
         end -- if
      end

   defer, short(f : EIFFEL_FORMAT) is
      do
         value.short(f)         
      end
   long, flat(f : EIFFEL_FORMAT) is
      do
         value.long(f)
      end
      
   copy(other : like Current) is
      do
         value := clone(other.value)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := value.is_equal(other.value)
      end
      
end -- class EIFFEL_TERM
