-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:46:23 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_token.e $
	-- Revision 1.3  1993/08/22  12:46:23  Neil_Wilson
	-- Added 'long' feature
	-- Added check for 'void' constant
	--
	-- Revision 1.2  1993/07/18  14:36:06  Neil_Wilson
	-- Added 'alter' feature.
	-- Using different formatter.
	-- Tokens respond to constant identity.
	--

class EIFFEL_TOKEN
-- A token for Eiffel

inherit
   TOKEN
      redefine 
         parse
      select
         parse
      end
   TOKEN
      rename
         parse as token_parse
      end
   EIFFEL_CONSTRUCT
      redefine
         short
      end
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end

creation
   parse

feature

  line : INTEGER
  -- the line the token appears on

  parse is
     do
        token_parse
	check_constant
        line := l.current_line
     end

   reset_type( t : INTEGER) is
      require
         type /= 0
      do
         type := t
      end

      -- Alteration - Neil Wilson, July 17, 1993
      
  is_constant: BOOLEAN
      -- Is this token a constant?

  set_constant is
      -- Mark the token as a constant
      do
	 is_constant := true
      end -- set_constant

      -- End of alteration

  upshort (f: EIFFEL_FORMAT) is
  do
  	f.class_name_write (terminal);
  end -- upshort
	       
	       -- Alteration, Neil Wilson, July 17, 1993

  defer (f : EIFFEL_FORMAT) is
     local
        c : STRING
        i : INTEGER
     do
        if type = Elex_comment
        then
           from
              i := 3
           until
              i > terminal.count
           loop
              c := "--"
              from
              until
                 i > terminal.count or else
                 terminal.item(i) = '%N'  
              loop
                 c.extend(terminal.item(i))
                 i := i + 1
              end
              f.comment_write(c)
              i := i + 3 -- the %N and a --
              if i <= terminal.count
              then
                 f.new_line
              end
           end
        elseif l.in(terminal.item(1),l.delimiters)
        then
           f.normal_write(terminal)
        elseif type > 0
        then
           if type = Elex_current
           then
              f.constant_write("Current")
           elseif type = Elex_result
           then
              f.constant_write("Result")
           else
              f.keyword_write(terminal)
           end
        else
	   f.attribute_write(terminal)
        end
     end
	       
       -- End of alteration

  long, flat, short(f : EIFFEL_FORMAT) is
     local
        c : STRING
        i : INTEGER
     do
        if type = Elex_comment
        then
           from
              i := 3
           until
              i > terminal.count
           loop
              c := "--"
              from
              until
                 i > terminal.count or else
                 terminal.item(i) = '%N'  
              loop
                 c.extend(terminal.item(i))
                 i := i + 1
              end
              f.comment_write(c)
              i := i + 3 -- the %N and a --
              if i <= terminal.count
              then
                 f.new_line
              end
           end
        elseif l.in(terminal.item(1),l.delimiters)
        then
           f.normal_write(terminal)
        elseif type > 0
        then
           if type = Elex_current
           then
              f.constant_write("Current")
           elseif type = Elex_result
           then
              f.constant_write("Result")
           else
              f.keyword_write(terminal)
           end
        else
	       -- Alteration, Neil Wilson, July 17, 1993
	   if is_constant then
	       f.constant_write (terminal)
	   else
	       f.attribute_write(terminal)
	   end
	       -- End of alteration
        end
     end

   infix "<" (other : like current):BOOLEAN is
      do
         Result := other.type = type and then terminal < other.terminal
      end


   copy (other : like Current) is
      do
         line := other.line
         terminal := clone(other.terminal)
         type := other.type
      end

   is_equal (other : like Current)  : BOOLEAN is
      do
         Result := line = other.line and then
                   type = other.type and then
                   equal(terminal,other.terminal)
      end

feature {NONE} -- Private features

 	check_constant is
		-- Looks to see if the token is a constant
	do
		if equal (terminal, "void") then
			set_constant
		end
	end -- check_constant

end -- class EIFFEL_TOKEN   
