-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/22 12:47:55 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: E_TYPE.E $
	-- Revision 1.3  1993/08/22  12:47:55  Neil_Wilson
	-- Added 'long' feature
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_TYPE 
-- A type in Eiffel - includes expanded, separate and like

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   expanded_type, separate_type, type : EIFFEL_CLASS_TYPE 
   like_type : EIFFEL_TOKEN
   bit_type : EIFFEL_BIT_TYPE

   parse is
      do
         if match(Elex_expanded)
         then
            consume
            !!expanded_type.parse
         elseif match(Elex_separate)
         then
            consume
            !!separate_type.parse
         elseif match(Elex_like)
         then
            consume
            if match(Elex_current) or match(Elex_result) or match(Elex_id)
            then
               !!like_type.parse
               consume
            else
               error("Expecting Current, Result or ID")
            end
         elseif match(Elex_bit)
         then
            !!bit_type.parse
         else
            !!type.parse
         end -- if
      end -- type

   long, defer, short(f : EIFFEL_FORMAT) is
      do
         if separate_type /= Void
         then
            f.keyword_write("separate")
            f.space
            separate_type.short(f)
         elseif like_type /= Void
         then
            f.keyword_write("like")
            f.space
            like_type.short(f)
         elseif expanded_type /= Void
         then
            f.keyword_write("expanded")
            f.space
            expanded_type.short(f)
         elseif bit_type /= Void
         then
            bit_type.short(f)
         else
            type.short(f)
         end -- if
      end

   supplier_classes : SET[STRING] is
      do
         if expanded_type /= Void
         then
            Result := expanded_type.supplier_classes
         elseif separate_type /= Void 
         then
            Result := separate_type.supplier_classes
         elseif type /= Void
         then
            Result := type.supplier_classes
         elseif bit_type /= Void
         then
            !!Result
            result.add("bit_n")
         else
            !!Result
         end
      end
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         expanded_type := clone(other.expanded_type)
         separate_type := clone(other.separate_type)
         type := clone(other.type)
         like_type := clone(other.like_type)
         bit_type := clone(other.bit_type)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(expanded_type, other.expanded_type) and then
            equal(separate_type, other.separate_type) and then
            equal(type, other.type) and then
            equal(like_type, other.like_type) and then
            equal(bit_type, other.bit_type)
      end
      
end -- class EIFFEL_TYPE
