-- Indent level skeleton

indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/08/22 12:50:45 $";
	revision: "$Revision: 1.1 $";
	licence: "GNU GPL - see file COPYING";
	log: 
	-- $Log: indent.e $
	-- Revision 1.1  1993/08/22  12:50:45  Neil_Wilson
	-- Initial revision
	--
	
deferred class INDENT

feature -- Comb indent facilities

	indent_level : INTEGER 
		-- The current indent level.

	increase_indent is
		-- Move the indent_level up.
	do
		indent_level := indent_level + 1
	ensure
		indent_level > old indent_level
	end -- increase_indent

	decrease_indent is
	require
		decreasable: indent_level > 0;
	do
		indent_level := indent_level - 1
	ensure
		indent_level < old indent_level
	end -- decrease_indent

	drop_indent is
		-- Clear the line indent
	do
		indent_level := 0
	ensure
		dropped: indent_level = 0;
	end -- drop_indent

	set_indent (num: INTEGER) is
		-- Move the indent to a specific value.
	require
		positive_indent: num >= 0
	do
		indent_level := num
	ensure
		set: indent_level = num
	end;

	indent is
		-- Move in another indent on current_line
	deferred
	ensure
		indent_level_up: indent_level > old indent_level
	end -- indent

feature {NONE} -- Indent facilities

	temp_indent: BOOLEAN
		-- Ask for the indent to be temporarily increased.

	indent_line is
		-- Set up the correct indent level.
	deferred
	ensure
		temp_off: not temp_indent
	end -- set_indent

invariant

	positive_indent: indent_level >= 0;

end -- class INDENT
