indexing

	date: "$Date: 1993/08/22 12:51:47 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: lex_eifl.e $
	-- Revision 1.3  1993/08/22  12:51:47  Neil_Wilson
	-- Correct support for multi-line strings
	--
	-- Revision 1.2  1993/07/18  15:40:26  Neil_Wilson
	-- Corrected mistake in character parsing
	--

class LEX_EIFFEL
-- a lexical analyser for Eiffel

inherit
   LEXICAL_EIFFEL_CONSTANT
   LEXICAL
      rename
         make as lex_make
      redefine
         get_next_token
      end
   
creation
   make

feature
 
   make is
      do
        lex_make
        delimiters.append("%'@#|&")
      end
 
   comment_start : STRING is
      once
         Result := "--"
      end

   get_next_token is
      -- gets the next token sets up all other required details
      do
         next_token := ""         
         token_type := 0
         skip_white_space
         collect_to_delimiter
         if next_token.count = 0 
         -- sitting immediately on a delimiter
         then
            next_token.extend(current_char)
            get_next_char
            if in(current_char,delimiters) 
               -- 2 delimiters may be a special token
            then
               next_token.extend(current_char)
               if is_a_terminal(next_token)
               then
                  get_next_char -- consume this char
               else
                  next_token := next_token.substring(1,1)
               end -- if
            end -- if
         end -- if
         if equal(next_token,".")
         then
            from
            until
               not in(current_char,"0123456789") or eof
            loop
               next_token.extend(current_char)
               get_next_char
            end
         end -- if
         if is_a_terminal(next_token)
         then
            -- this is a keyword
            token_type := terminals.find(next_token)
         else
            -- this is not a keyword
            -- work out what it is
            inspect next_token.item(1)
               when '%'' then process_char
               when '%"' then process_string
               when '0'..'9','.' then process_number
               when 'A'..'Z','a'..'z' then process_id
               when '@','#','|','&' then process_free
               else token_type := Elex_error
            end -- inspect
         end -- if
      end

    process_char is
       do
          -- three cases 'x', '%x' '%/int/'
          -- we have the initial '
          token_type := Elex_char
          if current_char = '%%'
          then
             if next_char = '/'
             then
                from
                   get_next_char -- over /
                   get_next_char -- first char
		       -- Alteration - Neil Wilson, July 17, 1993
		       -- Corrects mistake in this section.
                   next_token.append("%%/")
                until
                   not in(current_char,"0123456789") or eof
                loop
		   next_token.extend (current_char)
		       -- End of alteration
                   get_next_char
                end
                if current_char = '/' and next_char = '%''
                then
                   get_next_char
                   get_next_char
                   next_token.append("/'")
                end
             else -- a %x
                get_next_char -- over %
                if next_char = '%''
                then
                   next_token.extend('%%')
                   next_token.extend(current_char)
                   get_next_char -- over x of %x
                   next_token.extend('%'')
                   get_next_char -- over '
                else
                   token_type := Elex_error
                end
             end -- if
          elseif next_char = '%''
          then
             next_token.extend(current_char)
             get_next_char -- over x of 'x'
             get_next_char -- over 2nd ' of 'x'
             next_token.extend('%'')
          else
             token_type := Elex_error
          end -- if
       end
       
    process_string is
       local
          prevch : CHARACTER
       do
          from
             token_type := Elex_string
	     debug ("DSTRING")
	     	io.putstring ("%NEntering Process String%N");
	     end
          until
	  	(prevch /= '%%' and current_char = '%"') or
		token_type = Elex_error or eof
          loop
	     debug ("DSTRING")
		io.putstring (next_token);
	     	io.putstring (" - String loop%N");
	     end
             if current_char = '%%' and then (next_char='%N' or next_char='%R')
             then
		get_next_char;
                skip_white_space
                if current_char /='%%'
                then
                   token_type := Elex_error
                else
                   get_next_char
                end -- if
		debug ("DSTRING")
			io.putstring ("**Scanning newline, char is now *");
			io.putchar (current_char);
			io.putstring ("*%N");
		end;
	     else 
	     	next_token.extend (current_char)
		prevch := current_char
		get_next_char
	     end
	     debug ("DSTRING")
	     	io.putstring ("Previous = *");
		io.putchar (prevch);
		io.putstring ("*, Current = *");
		io.putchar (current_char);
		io.putstring ("*%N");
	    end
          end -- loop
          next_token.extend('%"')
          get_next_char
	  debug ("DSTRING")
	  	io.putstring ("Exiting process string%N");
	  end;
       end
       
    process_number is
       local
          i : INTEGER
          b : BOOLEAN
       do
          from
             i := 1
             b := true
          until
             i = next_token.count or not b
          loop
             b := in(next_token.item(i),"01")
             i := i + 1
          end
          if next_token.item(i)='b'
          then
             token_type := Elex_bitseq
          else
             from
                if next_token.item(1) = '.'
                then
                   i := 2
                else
                   i := 1
                end
                b := true
             until
                i > next_token.count or not b
             loop
                b := in(next_token.item(i),"0123456789")
                i := i + 1
             end
             if not b
             then
                token_type := Elex_error
             else
                if next_token.item(1) = '.'
                then
                   token_type := Elex_real
                else
                   token_type := Elex_int
                end
                if current_char = '.' and next_token.item(1) /= '.'
                then
                   token_type := Elex_real
                   get_next_char
                   next_token.extend('.')
                   from
                   until
                      not in(current_char,"0123456789") or eof
                   loop 
                      next_token.extend(current_char)
                      get_next_char
                   end
                   if current_char='E'
                   then
                      next_token.extend('E')
                      get_next_char
                      if in(current_char,"+-")
                      then
                         next_token.extend(current_char)
                         get_next_char
                      end
                      from
                      until
                         not in(current_char,"0123456789") or eof
                      loop
                         next_token.extend(current_char)
                         get_next_char
                      end
                   end -- if
                end-- if
             end -- if
          end -- if
       end
       
    process_id is
       local
          i : INTEGER
          b : BOOLEAN
       do
          b := true
          from
             i := 1
          until
             i > next_token.count or else 
             not in(next_token.item(i),alphanum) 
          loop
             i := i + 1
          end
          if b and in(next_token.item(1),alphabet)
          then
             token_type := Elex_id
             debug
                io.putstring("Got an id%N")
             end
          else
             token_type := Elex_error
          end -- if
       end

   Alphanum : STRING is
      once
         Result := clone(alphabet)
         Result.append("0123456789_")
      end

    process_free is
       do
          from
             token_type := Elex_free
          until
             in(current_char,whitespace)
          loop
             next_token.extend(current_char)
             get_next_char
          end -- loop
       end -- process_free

    create_lex is 
       do
         add_terminal("alias",elex_alias)
         add_terminal("all",elex_all)
         add_terminal("and",elex_and)
         add_terminal("and then",elex_andthen)
         add_terminal("as",elex_as)
         add_terminal("bit",elex_bit)
         add_terminal("check",elex_check)
         add_terminal("class",elex_class)
         add_terminal("creation",elex_creation)
         add_terminal("Current",elex_current)
         add_terminal("debug",elex_debug)
         add_terminal("deferred",elex_deferred)
         add_terminal("do",elex_do)
         add_terminal("else",elex_else)
         add_terminal("elseif",elex_elseif)
         add_terminal("end",elex_end)
         add_terminal("ensure",elex_ensure)
         add_terminal("expanded",elex_expanded)
         add_terminal("export",elex_export)
         add_terminal("external",elex_external)
         add_terminal("false",elex_false)
         add_terminal("feature",elex_feature)
         add_terminal("from",elex_from)
         add_terminal("frozen",elex_frozen)
         add_terminal("if",elex_if)
         add_terminal("implies",elex_implies)
         add_terminal("indexing",elex_indexing)
         add_terminal("infix",elex_infix)
         add_terminal("inherit",elex_inherit)
         add_terminal("inspect",elex_inspect)
         add_terminal("invariant",elex_invariant)
         add_terminal("is",elex_is)
         add_terminal("like",elex_like)
         add_terminal("local",elex_local)
         add_terminal("loop",elex_loop)
         add_terminal("not",elex_not)
         add_terminal("obsolete",elex_obsolete)
         add_terminal("old",elex_old)
         add_terminal("once",elex_once)
         add_terminal("or",elex_or)
         add_terminal("or else",elex_orelse)
         add_terminal("prefix",elex_prefix)
         add_terminal("redefine",elex_redefine)
         add_terminal("rename",elex_rename)
         add_terminal("require",elex_require)
         add_terminal("rescue",elex_rescue)
         add_terminal("result",elex_result)
         add_terminal("retry",elex_retry)
         add_terminal("select",elex_select)
         add_terminal("separate",elex_separate)
         add_terminal("strip",elex_strip)
         add_terminal("then",elex_then)
         add_terminal("true",elex_true)
         add_terminal("undefine",elex_undefine)
         add_terminal("unique",elex_unique)
         add_terminal("until",elex_until)
         add_terminal("variant",elex_variant)
         add_terminal("when",elex_when)
         add_terminal("xor",elex_xor)
         add_terminal("--",-elex_comment)
         add_terminal("->",elex_arrow)
         add_delimiter(";",elex_semi)
         add_delimiter(",",elex_comma)
         add_terminal(":=",elex_assign)
         add_delimiter(":",elex_colon)
         add_terminal("..",elex_dotdot)
         add_delimiter(".",elex_dot)
         add_delimiter("!",elex_bang)
         add_delimiter("=",elex_equal)
         add_terminal("/=",elex_nequal)
         add_terminal("//",elex_div)
         add_delimiter("/",elex_divide)
         add_delimiter("(",elex_lbracket)
         add_delimiter(")",elex_rbracket)
         add_delimiter("[",elex_lsqbracket)
         add_delimiter("]",elex_rsqbracket)
         add_delimiter("{",elex_lbrace)
         add_delimiter("}",elex_rbrace)
         add_terminal("<<",elex_lmanarr)
         add_terminal(">>",elex_rmanarr)
         add_delimiter("<",elex_lessthan)
         add_delimiter(">",elex_greaterthan)
         add_terminal("<=",elex_lessequal)
         add_terminal(">=",elex_greatequal)
         add_terminal("?=",elex_revassign)
         add_delimiter("?",elex_question)
         add_delimiter("+",elex_plus)
         add_delimiter("-",elex_minus)
         add_delimiter("$",elex_dollar)
         add_delimiter("*",elex_star)
         add_delimiter("^",elex_caret)
         add_terminal("\\",elex_mod)
         add_delimiter("\",elex_backslash)
      end

end -- class LEX_EIFFEL
