class LLIST[G] 
-- a doubly linked list 

inherit
   ANY
      redefine
         copy,
         is_equal
      end

creation
   make

feature

   add_right(x : G) is
      require
--         x /= Void
      local
         l : like first_elem
      do
         !!l.make(x)
         if cursor /= Void
         then
            if cursor.next /= Void
            then
               l.connect_next(cursor.next)
            end
            cursor.connect_next(l)
            if last_elem.next /= Void
            then
               last_elem := last_elem.next
            end
         else
            first_elem := l
            last_elem := l
         end
         cursor := l
         count := count + 1
         off_left := false
         off_right := false
      end

   add_left(x : G) is
      require
--         x /= Void
      local
         l : like first_elem
      do
      end
      
   put(x : G) is
      do
         finish
         add_right(x)
      end

   count : INTEGER

   first_elem : LINK[G]

   last_elem : like first_elem

   cursor : like first_elem

   remove is
   -- remove the element at the cursor
   -- move the cursor to the left
      require
         not off_left
         not off_right
      local
         l : like cursor
      do
         l := cursor
         if last_elem = cursor
         then
            -- get this move correctly
            off_left := last_elem = Void
         end
         if first_elem = cursor
         then
            first_elem := cursor.next
            off_right := first_elem = Void
         end
         if cursor.next /= Void
         then
            cursor := cursor.next
         else
            cursor := Void
            off_right := true
            off_left := true
         end
         count := count - 1               
      end

   insert( other : like current) is
   -- insert the new list other at the cursor
      require
         inside : not off_right and not off_left
      local
         t : like first_elem
      do
         t := cursor.next
         cursor.connect_next(other.first_elem)
         other.last_elem.connect_next(t)
         count := count + other.count
      end

   append(other : like Current) is
   -- insert the list at the end
      do
         finish
         if off_right
         then
            first_elem := other.first_elem
            last_elem := other.last_elem
            count := other.count
            cursor := first_elem
         else
            insert(other)
         end
      end

   back is
      do
      end

   forth is
      do
         cursor := cursor.next
         off_right := cursor = Void
      end

   start is
      do
         cursor := first_elem
         off_right := cursor = Void
         off_left := cursor = Void
      end

   finish is
      do
         cursor := last_elem
         off_right := cursor = Void
         off_left := cursor = Void
      end

   nth(n : INTEGER):G is
      require
         n <= count
      local
         t : like first_elem
         i : INTEGER
      do
         from
            t := first_elem
            i := 1
         until
            i = n
         loop
            t := t.next
            i := i + 1
         end -- loop        
         Result := t.item
      end -- nth

   first : G is
      do
         Result := first_elem.item
      end

   last : G is
      do
         Result := last_elem.item
      end

   item : G is
      do
         Result := cursor.item
      end

   mark is
       do
          marked := cursor
       end

   return is
      do
         cursor := marked
      end

   off_left, off_right : BOOLEAN

   make is
      do
         off_left := true
         off_right := true
      end

   find(x : G) is
      do
         from
            start
         until
            cursor = Void or else item = x
         loop
            forth
         end
      end

   in(x : G) : BOOLEAN is
      local
         t : like first_elem
      do
         from
            t := first_elem
         until
            t = Void or else Result
         loop
            Result := t.item = x
            t := t.next
         end
      end

   in_equal(x : G) : BOOLEAN is
      local
         t : like first_elem
      do
         from
            t := first_elem
         until
            t = Void or else Result
         loop
            Result := equal(t.item,x)
            t := t.next
         end
      end

   remove_all is
      do
         first_elem := Void
         last_elem := Void
         cursor := Void
         off_left := true
         off_right := true   
      end

   to_array : ARRAY[G] is
       local
          i : INTEGER
       do
          !!Result.make(1,count)
          from
             i := 1
             mark
          until
             off_right
          loop
             Result.put(item,i)
             i := i + 1
             forth
          end -- loop
          return
      end -- to_array

   at_end : BOOLEAN is 
      do
         Result := item = last
      end -- at end

   at_start : BOOLEAN is 
      do
         Result := item = first
      end -- at start
      
   marked : like first_elem

   is_equal( other : like Current)  : BOOLEAN is
      do
         if other = current
         then
            Result := true
         else
            from
               mark
               other.mark
               Result := true
               start
               other.start
            until
               off_right or else
               other.off_right
            loop
               Result := item.is_equal(other.item)
               forth
               other.forth
            end
            return
            other.return
            Result := Result and then off_right and other.off_right
         end
      end

   copy( other : like Current) is
      do
         from
            wipe_out
            other.start
         until
            other.off_right
         loop
            put(clone(other.item))
            other.forth
         end
      end

   wipe_out is
      do
         first_elem := Void
         last_elem := Void
         cursor := Void
         count := 0
         marked := Void
         off_right := true
         off_left := true
      end

   empty : BOOLEAN is
      do
         Result := count = 0
      end

end -- class DLLIST
