-- Eiffel Short class abstracter

indexing
	
	type: root, user;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/08/01 10:35:29 $";
	revision: "$Revision: 1.5 $";
	original_by: "David_Morgan";
	licence: "GNU GPL - see file COPYING";
	log: 
	-- $Log: short.e $
	-- Revision 1.5  1993/08/01  10:35:29  Neil_Wilson
	-- Abstracted away version information
	-- to prevent tool version number from depending on this
	-- class revision
	--
	-- Revision 1.4  1993/08/01  09:57:02  Neil_Wilson
	-- Added constraint to formatter.
	-- Ensure that formatter is reset between input files.
	--
	-- Revision 1.3  1993/07/18  15:27:59  Neil_Wilson
	-- Added file checking and exception support
	-- Added version and help details.
	-- Added new options.
	-- Using new improved ascii formatter.
	--
	-- Revision 1.2  1993/07/04  17:33:50  Neil_Wilson
	-- Added command line argument support
	--
	-- Revision 1.1  1993/07/04  08:25:43  David_Morgan
	-- Initial revision
	--

class SHORT

inherit

	SHORT_VERSION

	STORAGE_DEVICES

	EXCEPTION

creation

	make

feature -- Bring the processor into being

	make is
		-- Execute the short system
	do
		initialise_environment;
		if env.has_invalid_option then
			option_error
		else
			handle_options;
			debug
				io.putstring (view_name);
				io.new_line;
				io.putbool (want_parents);
				io.new_line;
				io.putbool (want_defer);
				io.new_line;
			end;
			if want_version then
				display_version
			else
				short_arguments
			end;
		end
	end -- make

feature {NONE} -- Defaults

	default_view_name: STRING is "ANY";
		-- Short displays public interface by default.

	default_indent_step: INTEGER is 8;

	default_width: INTEGER is 80;

	Lexical_error: INTEGER is 1;
		-- Exception code returned by the lexer.

feature {NONE} -- System option routines.

	want_parents: BOOLEAN;
		-- Should short display the inheritance clause?

	want_defer: BOOLEAN;
		-- Output fully deferred class instead of short?

	want_version: BOOLEAN;
		-- Display the version details and exit?

	view_name: STRING;
		-- Display short in terms of this class

	env: PREPARED_ENVIRONMENT;
		-- Options, arguments and environmental variables.

	format: ASCII_FORMAT;
		-- Output formatter

	initialise_environment is
		-- Split the command line into options and arguments
	local
		op: MULTIPLE_OPTION;
		list: SHORT_LIST [OPTION_MATCHER];
		short: UNIX_MATCHER;
		long: GNU_MATCHER
	do
		!!short.make;
		short.add ("epVfh");
		short.add_required ("l", "class_name");
		short.add_required ("b", "number");
		short.add_required ("c", "number");
		!!long.make
		long.add ("eiffel");
		long.add ("abstract");
		long.add ("parents");
		long.add ("version");
		long.add ("help");
		long.add ("full");
		long.add_required ("view", "class_name");
		long.add_required ("blank", "number");
		long.add_required ("column", "number");
		!!list.make (false);
		list.add (long);
		list.add (short);
		!!op.make (list);
		!!env.make (op);
	ensure
		environment_prepared: env /= Void
	end -- initialise_environment

	handle_options is
		-- Set system flags to option values
	require
		environment_there: env /= Void
		valid_options: not env.has_invalid_option
	local
		fmt: FORMAT
	do
		!!fmt
		if env.options.has ("b") then
			!!format.make (fmt.s2i (env.options.at ("b")))
		elseif env.options.has ("blank") then
			!!format.make (fmt.s2i (env.options.at ("blank")))
		else
			!!format.make (default_indent_step)
		end
		if env.options.has ("c") then
			format.set_width (fmt.s2i (env.options.at ("c")));
		elseif env.options.has ("column") then
			format.set_width (fmt.s2i (env.options.at ("column")));
		else
			format.set_width (default_width);
		end;
		if env.options.has ("f") or env.options.has ("full") then
			view_from ("none");
		elseif env.options.has ("l") then
			view_from (env.options.at ("l"));
		elseif env.options.has ("view") then
			view_from (env.options.at ("view"))
		else
			view_from (default_view_name);
		end;
		want_defer := env.options.has ("e")
		    or env.options.has ("eiffel")
		    or env.options.has ("abstract");
		want_parents := env.options.has ("p")
		    or env.options.has ("parents");
		want_version := env.options.has ("V") or env.options.has ("h")
		    or env.options.has ("version") or env.options.has ("help");
	ensure
		view_available: view_name /= Void and then not view_name.empty
		formatter_available: format /= Void
	end -- handle_options

	view_from (class_name: like view_name) is
		-- Set the class short will give the view for.
	do
		if class_name = Void or else class_name.empty then
			view_name := "NONE"
		else
			view_name := class_name;
			view_name.to_upper
		end
	ensure
		view_available: view_name /= Void and then not view_name.empty
	end -- view_from

feature {NONE} -- Message output routines

	error_output (s: STRING) is
		-- Place an error_message on the standard error
	require
		string_available: s /= Void
	do
		io.set_error_default;
		io.putstring (env.program_name);
		io.putstring (": ");
		io.putstring (s)
		io.new_line
		io.set_output_default
	ensure
		-- messages go to standard_output
	end -- error_output

	option_error is
		-- Output error message
	require
		enviroment_prepared: env /= Void
		correct_call: env.has_invalid_option
	do
		io.set_error_default;
		io.putstring (env.invalid_option);
		io.new_line;
		io.putstring (env.help);
		io.putstring (" [filename ...]");
		io.new_line;
		io.set_output_default;
	ensure
		-- messages go to standard_output
	end -- option_error
	
	display_version is
		-- Output version details and help
	require
		enviroment_prepared: env /= Void
	do
		io.set_error_default;
		io.putstring (Title_string)
		io.new_line
		io.putstring (Current_version);
		io.new_line;
		io.putstring (env.help);
		io.putstring (" [filename ...]");
		io.new_line;
		io.set_output_default
	ensure
		-- messages go to standard_output
	end -- display_version

feature {NONE} -- File access checking

	current_filename: STRING
		-- Name of the file being processed

	file_accessible: BOOLEAN
		-- Is the current_filename a readable file?

	check_file_access is
		-- Set file_accessible attribute.
	require
		filename_available: current_filename /= Void 
	local
		scratch: STRING;
		file_exception: BOOLEAN;
		hook: INTEGER
	do
		file_accessible := true; -- Assume OK.
		scratch := clone (current_filename);
		if current_filename.empty then
			file_accessible := false;
			-- Ignore empty filenames
		elseif file_exception or else not fs.has_listperm
		    (fs.path_prefix (current_filename)) then
			file_accessible := false
			scratch.append (": cannot access path");
			error_output (scratch);
		elseif not fs.file_exists (current_filename) then
			file_accessible := false
			scratch.append (": file not found");
			error_output (scratch);
		elseif not fs.has_readperm (current_filename) then
			file_accessible := false
			scratch.append (": cannot read file");
			error_output (scratch);
		else
			-- Attempt to access file, should flush out
			-- any other access problems in form of exception
			-- Yes I know it's messy...
			-- Neil Wilson, July 18, 1993
			hook := fs.access_file (current_filename, "r", false);
		end
	ensure
		correct_access: file_accessible implies
		    fs.has_readperm (current_filename);
	rescue
		-- I'm not happy about this, but it's the best I can do
		-- given the anonymous exceptions raised by SIG's file
		-- system. - Neil Wilson, July 18, 1993
		if not file_exception then
			file_exception := true;
			retry
		end;
	end -- check_file_access

feature {NONE} -- class abstraction routines

	short_arguments is
		-- Run the class abstractor on each argument
	require
		environment_prepared: env /= Void
	local
		stdin: REWINDABLE_STDIN;
		str: REWINDABLE_FILE;
		i: INTEGER
	do
		if env.arg_count = 0 then
			!!stdin.open
			current_filename := "stdin";
			short_stream (stdin);
		else
			from
				i := 1
			variant
				env.arg_count - i + 1
			until
				i > env.arg_count
			loop
				debug
					io.putint (i);
					io.putstring (" File: ");
					io.putstring (env.arg_item (i));
				end;
				current_filename := env.arg_item (i);
				check_file_access;
				if file_accessible then
					!!str.open (current_filename)
					short_stream (str);
				end;
				i := i + 1
			end
		end
	end -- short_arguments

	short_stream (strm: REWINDABLE_CHARACTER_STREAM) is
		-- Produce relevant output from the stream
	require
		stream_connected: strm /= Void and then strm.is_connected
		name_available: current_filename /= Void and then
		    not current_filename.empty
		formatter_stable: format /= Void
		    and then format.indent_level = 0
	local
		c: EIFFEL_CLASS
		lexical_failure: BOOLEAN
		error_string: STRING
	do
		if lexical_failure then
			error_output (error_string);
		else
			!!c.connect_stream (strm)
			c.parse
			strm.close
			c.set_want_parents (want_parents);
			c.set_view_name (view_name);
			if want_defer then
				c.defer (format);
			else
				c.short (format);
			end
		end;
	ensure
		formatter_stable: format /= Void
		    and then format.indent_level = 0
	rescue
		inspect last_ecode
		when Lexical_error then
			lexical_failure := true;
			error_string := clone (current_filename);	
			error_string.append (": ");
			error_string.append (last_etext);
			retry
		end;
	end -- short_stream
	
end -- class SHORT
