-- Copyright (c) 1993 by:
--    Ulter Systems Ltd.                  Pulse Train Technology Ltd.
--    77 Schelkovskoe Shosse              30 Alan Turing Road
--    107497 Moscow, Russia               Guilford, Surrey GU2 5AA, England
--    tel./fax +7095 460 4710             tel. +44 483 300 100
--                                        fax  +44 483 302 194
----------------------------------------------------------------------------
-- Name        : CALCULATOR
-- ACN         :
-- Cluster     :
-- Test        :
-- Author      : Dmitry Mastrukov
-- Entered     : 03-20-93
-- Lines       :
----------------------------------------------------------------------------
-- Description :
----------------------------------------------------------------------------
----------------------------------------------------------------------------
-- Purpose     :
----------------------------------------------------------------------------
-- Updated     :
-- Added       :
-- Deleted     :
-- Changed     :
-- Lines       :
-- Description :
----------------------------------------------------------------------------
class CALCULATOR
inherit
   DIALOG
   rename
      make as dlg_make
   redefine
      set_data, on_clicked,
   select
      init, set_data, on_clicked
   end;
creation
   make
feature
   ---------------------------------------------------- buttons
   -- Button contexts
   --
   BTN_1, BTN_2, BTN_3, BTN_4, BTN_5, BTN_6, BTN_7, BTN_8, BTN_9, BTN_0,
   BTN_SIGN, BTN_DOT,
   BTN_PLUS, BTN_MINUS, BTN_MUL, BTN_DIV,
   BTN_DO, BTN_CLEAR, BTN_CANCEL : INTEGER is UNIQUE;
   ---------------------------------------------------- data
   -- display
   screen : STATIC_TEXT;
   contents : STRING;
   -- buttons
   b, b0, b1, b2, b3, b4, b5, b6, b7, b8, b9,
   bsign, bdot, bplus, bminus, bmul, bdiv,
   bdo, bclear, bcancel : TEXT_BUTTON;
   --
   -- button groups
   -- used only for auto justification.
   --
   bg : BUTTON_GROUP;
   --
   -- State control
   --
   state : INTEGER;
   operation : INTEGER;
   register : REAL;
   --
   -- State constants
   --
   ST1, -- Register empty, screen erasable
   ST2, -- Register empty, screen appendable
   ST3, -- Register not empty, screen erasable
   ST4  -- Register not empty, screen appendable
   : INTEGER is UNIQUE;
   --
   ---------------------------------------------------- make
   -- Creation of calculator
   --
   make () is
   local
      r : RECT;
   do
      !!r.make ( 20, 20, 203, 210 );
      dlg_make ( "Eiffel Calculator", r );

      !!r.make ( 5, 5, -10, 20 );
      !!screen.make ( "0", r );
      add ( screen );

      !!r.make ( 5, 30, -10, 30 );
      !!bg.make ( Void, r, HORIZONTAL, true, 0.2 );
      !!bdo.make     ( " = ", null_rect, BTN_DO );
      !!bclear.make  ( " C ", null_rect, BTN_CLEAR );
      !!bcancel.make ( "OFF", null_rect, BTN_CANCEL );
      bg.add ( bdo );
      bg.add ( bclear );
      bg.add ( bcancel );
      add ( bg );

      !!r.make ( 5, 60, -10, 30 );
      !!bg.make ( Void, r, HORIZONTAL, true, 0.2 );
      !!b.make ( " 7 ", null_rect, BTN_7 );   bg.add ( b );
      !!b.make ( " 8 ", null_rect, BTN_8 );   bg.add ( b );
      !!b.make ( " 9 ", null_rect, BTN_9 );   bg.add ( b );
      !!bdiv.make ( " / ", null_rect, BTN_DIV ); bg.add ( bdiv );
      add ( bg );

      !!r.make ( 5, 90, -10, 30 );
      !!bg.make ( Void, r, HORIZONTAL, true, 0.2 );
      !!b.make ( " 4 ", null_rect, BTN_4 );   bg.add ( b );
      !!b.make ( " 5 ", null_rect, BTN_5 );   bg.add ( b );
      !!b.make ( " 6 ", null_rect, BTN_6 );   bg.add ( b );
      !!bmul.make ( " * ", null_rect, BTN_MUL ); bg.add ( bmul );
      add ( bg );

      !!r.make ( 5, 120, -10, 30 );
      !!bg.make ( Void, r, HORIZONTAL, true, 0.2 );
      !!b.make ( " 1 ", null_rect, BTN_1 );     bg.add ( b );
      !!b.make ( " 2 ", null_rect, BTN_2 );     bg.add ( b );
      !!b.make ( " 3 ", null_rect, BTN_3 );     bg.add ( b );
      !!bminus.make ( " - ", null_rect, BTN_MINUS ); bg.add ( bminus );
      add ( bg );

      !!r.make ( 5, 150, -10, 30 );
      !!bg.make ( Void, r, HORIZONTAL, true, 0.2 );
      !!b.make ( " 0 ", null_rect, BTN_0 );    bg.add ( b );
      !!b.make ( "+/-", null_rect, BTN_SIGN ); bg.add ( b );
      !!bdot.make ( " . ", null_rect, BTN_DOT );  bg.add ( bdot );
      !!bplus.make ( " + ", null_rect, BTN_PLUS ); bg.add ( bplus );
      add ( bg );
   end;
   ---------------------------------------------------- on_clicked
   on_clicked ( t : TILE ) : INTEGER is
   local
      i : INTEGER;
      s : STRING;
   do
      result := processed;

      if t.context /= BTN_CANCEL then
         inspect
            state
         when ST1 then
            inspect
               t.context
            when BTN_1..BTN_0  then
               erase_screen();
               append_screen ( t.context );
               state := ST2;
            when BTN_PLUS..BTN_DIV then
               store_operation ( t.context );
               disable_operations();
               bdot.enable();
               state := ST3;
            when BTN_DOT then
               reset_screen();
               append_screen ( BTN_DOT );
               bdot.disable();
               state := ST2;
            when BTN_SIGN then
               invert_sign();
               state := ST2;
            when BTN_CLEAR then
               reset_screen();
            else
               result := not_processed;
            end; -- inspect
         when ST2 then
            inspect
               t.context
            when BTN_1..BTN_0  then
               append_screen ( t.context );
            when BTN_PLUS..BTN_DIV then
               store_operation ( t.context );
               disable_operations();
               bdot.enable();
               state := ST3;
            when BTN_DOT then
               append_screen ( BTN_DOT );
               bdot.disable();
            when BTN_SIGN then
               invert_sign();
            when BTN_CLEAR then
               reset_screen();
               bdot.enable();
               state := ST1;
            else
               result := not_processed;
            end; -- inspect
         when ST3 then
            inspect
               t.context
            when BTN_1..BTN_0  then
               erase_screen();
               append_screen ( t.context );
               state := ST4;
            when BTN_DOT then
               reset_screen();
               append_screen ( BTN_DOT );
               bdot.disable();
               state := ST4;
            when BTN_SIGN then
               invert_sign();
            when BTN_CLEAR then
               reset_screen();
               enable_operations();
               state := ST1;
            when BTN_DO then
               execute_command();
               enable_operations();
               bdot.enable();
               state := ST1;
            else
               result := not_processed;
            end; -- inspect
         when ST4 then
            inspect
               t.context
            when BTN_1..BTN_0  then
               append_screen ( t.context );
            when BTN_DOT then
               append_screen ( BTN_DOT );
               bdot.disable();
            when BTN_SIGN then
               invert_sign();
            when BTN_CLEAR then
               reset_screen();
               bdot.enable();
               state := ST3;
            when BTN_DO then
               execute_command();
               enable_operations();
               bdot.enable();
               state := ST1;
            else
               result := not_processed;
            end; -- inspect
         else
            result := not_processed;
         end; -- inspect
      else
         terminate (0);
      end; -- if

   end;
   ---------------------------------------------------- set_data
   set_data() is
   do
      set_default_button ( bdo );
      set_cancel_button ( bcancel );

      screen.justify_right();
      !!contents.adapt ( "0" );
      state := ST1;
      operation := 0;
      register := 0;
   end;
   ---------------------------------------------------- logical object methods
   -- These methods belongs to calculator itself,
   -- not a screen object.
   --
   ---------------------------------------------------- erase_screen
   erase_screen() is
   do
      contents.adapt("");
      screen.set_name ( contents );
   end;
   ---------------------------------------------------- reset_screen
   reset_screen() is
   do
      contents.adapt ( "0" );
      screen.set_name ( contents );
   end;
   ---------------------------------------------------- append_screen
   append_screen ( code : INTEGER ) is
   local
      ch : CHARACTER;
   do

      inspect
         code
      when BTN_0 then
         ch := '0';
      when BTN_1 then
         ch := '1';
      when BTN_2 then
         ch := '2';
      when BTN_3 then
         ch := '3';
      when BTN_4 then
         ch := '4';
      when BTN_5 then
         ch := '5';
      when BTN_6 then
         ch := '6';
      when BTN_7 then
         ch := '7';
      when BTN_8 then
         ch := '8';
      when BTN_9 then
         ch := '9';
      else
         ch := '.';
      end; -- inspect
      contents.extend ( ch );
      screen.set_name ( contents );
   end;
   ---------------------------------------------------- store_operation
   store_operation ( code : INTEGER ) is
   local
      f : FORMAT;
   do
      !!f;
      operation := code;
      register := f.s2r ( contents );
   end;
   ---------------------------------------------------- invert_sign
   invert_sign () is
   do
      if contents.substring ( 1, 1 ).is_equal ( "-" ) then
         contents.remove (1);
      else
         contents.precede ( '-' );
      end; -- if
      screen.set_name ( contents );
   end;
   ---------------------------------------------------- disable_operation
   disable_operations() is
   do
      bmul.disable()
      bdiv.disable()
      bplus.disable()
      bminus.disable()
   end;
   ---------------------------------------------------- enable_operation
   enable_operations() is
   do
      bmul.enable()
      bdiv.enable()
      bplus.enable()
      bminus.enable()
   end;
   ---------------------------------------------------- execute_command
   execute_command() is
   local
      val : REAL;
      f : FORMAT;
   do
      !!f;
      val := f.s2r ( contents );
      --
      inspect
         operation
      when BTN_PLUS then
         val := register + val;
      when BTN_MINUS then
         val := register - val;
      when BTN_MUL then
         val := register * val;
      when BTN_DIV then
         if val /= 0 then
            val := register / val;
         else
            val := 0;
         end; -- if
      else
         val := 0;
      end; -- inspect
      --
      contents := f.r2s ( "", val );
      screen.set_name ( contents );

      if contents.count > 1 then
         from
         until
            contents.substring ( contents.count, contents.count ).is_equal ( "0") = FALSE
         loop
            contents.remove ( contents.count );
         end; -- loop
      end; -- if

      if contents.substring ( contents.count, contents.count ).is_equal ( "." ) then
         contents.remove ( contents.count );
      end; -- if

      screen.set_name ( contents );
   end;
   ---------------------------------------------------- invariant
invariant
end


