-- Copyright (c) 1993 by:
--    Ulter Systems Ltd.                  Pulse Train Technology Ltd.
--    77 Schelkovskoe Shosse              30 Alan Turing Road
--    107497 Moscow, Russia               Guilford, Surrey GU2 5AA, England
--    tel./fax +7095 460 4710             tel. +44 483 300 100
--                                        fax  +44 483 302 194
----------------------------------------------------------------------------
-- Name        : DEMO_APP
-- ACN         :
-- Cluster     :
-- Test        :
-- Author      : Nicolas_Abou_Rjeily.
-- Entered     : 03-10-93 06:28pm
-- Lines       :
----------------------------------------------------------------------------
-- Description : This is a multiwindow text editing application.
----------------------------------------------------------------------------
class DEMO_APP
inherit
   APPLICATION
      rename
         make as a_make,
         on_event as a_on_event
   end;
   APPLICATION
      rename
         make as a_make
      redefine
         on_event, make_menu, on_rbutton_down
      select
         on_event, make_menu, on_rbutton_down, init
   end;
   SYSTEM_COMMAND
   COMMON


creation
   make
-----------------------------------------------------------------------------
feature {ANY}

   window : MENU;    -- Used as a standalone popup menu invoked by
                     -- left mouse button.

-----------------------------------------------------------------------------
feature { ANY }
      matrix : DATA_MODEL
      open_dlg, save_dlg, open_multiple : FILE_DIALOG;


feature { NONE }

      edit_field  : MEMO_ENTRY
      edit_count  : INTEGER;
      table_count : INTEGER;
      te_count : INTEGER;

   ---------------------------------------------------- filter_table
   filter_table: ARRAY [ STRING ] is
   once
      !!Result.make(1,6);
      Result.force("Text files (*.txt)", 1);
      Result.force("Eiffel Source Files (*.e)", 2);
      Result.force("C Source Files (*.c)", 3);
      Result.force("Project files (*.pdl)", 4);
      Result.force("System files (*.bat;*.sys;*.ini)", 5);
      Result.force("All files (*.*)", 6);
   end; -- filter_table
feature {ANY}
   ---------------------------------------------------- make
   make ( appname : STRING ) is
      -- The creation procedure of an application receives
      -- only one parameter : Application Name
   do
       a_make ( appname );

      !!open_dlg.make_open("EPWL Open File Dialog", filter_table);
      !!save_dlg.make_save("EPWL Save As File Dialog", filter_table);
      !!open_multiple.make_open_multiple("EPWL Open Multiple File Dialog", filter_table);

      table_count := 1;
      te_count := 1;
      edit_count := 1;
      !!matrix.make(3,150);
   end;

   ---------------------------------------------------- make_menu
   make_menu () : MENU is
      -- This function makes it possible to attach menu to
      -- application frame.
   local
      file, edit, help, tools, tbl, just, text, graph, treeview : MENU;
      item	: MENU_ITEM;
      entry	: MENU_ENTRY;
      popup : SUB_MENU_ITEM;
   do
      !!file.make;
      !!item.make("&New",        0, IDM_NEW      ); file.add(item);
      !!item.make("&Open ...",   0, IDM_OPEN     ); file.add(item);
      !!item.make("&Save",       0, IDM_SAVE     ); file.add(item);
                                                    item.deactivate();
      !!item.make("Save &As...", 0, IDM_SAVEAS   ); file.add(item);
                                                    item.deactivate();
      !!item.make("&Close",      0, IDM_CLOSE    ); file.add(item);
      !!entry.make_separator                        file.add(entry);
      !!item.make("Open &Multiple...", 0, IDM_OPEN_MULTIPLE ); file.add(item);
      !!item.make("Close Al&l",  0, IDM_CLOSE_ALL); file.add(item);
      !!entry.make_separator                        file.add(entry);
      !!item.make("&Print",      0, IDM_PRINT    ); file.add(item);
                                                    item.deactivate();
      !!item.make("P&rint Setup",0, IDM_PRINT_SETUP); file.add(item);
      !!entry.make_separator                        file.add(entry);
      !!item.make("E&xit",       0, IDM_QUIT     ); file.add(item);

      !!edit.make;
      !!item.make("&Undo",       0, IDM_UNDO      ); edit.add(item);
      !!item.make("&Redo Undo",  0, IDM_REDO      ); edit.add(item);
      !!entry.make_separator                         edit.add(entry);
      !!item.make("Cu&t",        0, IDM_CUT       ); edit.add(item);
      !!item.make("&Copy",       0, IDM_COPY      ); edit.add(item);
      !!item.make("&Paste",      0, IDM_PASTE     ); edit.add(item);
      !!item.make("C&lear",      0, IDM_CLEAR     ); edit.add(item);
      !!entry.make_separator                         edit.add(entry);
      !!item.make("&Select All", 0, IDM_SELECT_ALL); edit.add(item);

      !!window.make;
      !!item.make("&Cascade"      , 0, IDM_CASCADE   ); window.add(item);
      !!item.make("&Tile"         , 0, IDM_TILE      ); window.add(item);
      !!item.make("Arrange &Icons", 0, IDM_ARRANGE   ); window.add(item);

      !!tools.make;
      !!item.make("&Calculator"   , 0, IDM_CALC      ); tools.add(item);

      !!tbl.make;
      !!item.make("&New"          , 0, IDM_NEWTABLE  ); tbl.add(item);
      !!item.make("&Edit cell"    , 0, IDM_TBLDLG    ); tbl.add(item);

      !!just.make;
      !!item.make ( "Flash &left",  0, IDM_HL ); just.add(item);
      !!item.make ( "Flash &right", 0, IDM_HR ); just.add(item);
      !!item.make ( "&Center",      0, IDM_HC ); just.add(item);
      !!entry.make_separator                     just.add(entry);
      !!item.make ( "&Top",         0, IDM_VT ); just.add(item);
      !!item.make ( "&Bottom",      0, IDM_VB ); just.add(item);
      !!item.make ( "&Middle",      0, IDM_VC ); just.add(item);

      !!text.make;
      !!item.make ( "&New TXE",        0, IDM_NEWTEXT ); text.add(item);
      !!entry.make_separator                          text.add(entry);
      !!item.make ( "&Set text...",    0, IDM_TEXT ); text.add(item);
      !!popup.make( "&Justification",   0, just     ); text.add(popup);
      !!item.make ( "&Attributes",      0, IDM_ATTR ); text.add(item);
      !!item.make ( "S&pecials",        0, IDM_SPEC ); text.add(item);

      !!treeview.make
      !!item.make ( "&New Tree"  , 0, IDM_NEWTREE );          treeview.add(item);
      !!entry.make_separator                                  treeview.add(entry);
      !!item.make ( "&Expand all", 0, IDM_BP_EXPANDALL );     treeview.add(item);
      !!item.make ( "&Collapse branch", 0, IDM_BP_COLLAPSE ); treeview.add(item);
      !!item.make ( "&Level up", 0, IDM_BP_UP );              treeview.add(item);
      !!entry.make_separator                                  treeview.add(entry);
      !!item.make ( "&More columns",  0, IDM_INC_COLS );      treeview.add(item);
      !!item.make ( "Le&ss columns", 0, IDM_DEC_COLS );       treeview.add(item);

      !!graph.make;
      !!item.make("&New"          , 0, IDM_NEWGRAPH  ); graph.add(item);
      !!item.make("&Edit..."      , 0, IDM_EDITGRAPH ); graph.add(item);

      !!help.make;
      !!item.make("&About"        , 0, IDM_ABOUT     ); help.add(item);

      !!Result.make_root;
      !!popup.make("&File"       ,0,   file);      Result.add(popup);
      !!popup.make("&Edit"       ,0,   edit);      Result.add(popup);
      !!popup.make("&Table"      ,0,   tbl  );     Result.add(popup);
      !!popup.make("Te&xt"       ,0,   text);      Result.add(popup);
      !!popup.make("T&ools"      ,0,   tools);     Result.add(popup);
      !!popup.make("&Graphic"    ,0,   graph);     Result.add(popup);
      !!popup.make("T&ree"       ,0,   treeview);  Result.add(popup);
      !!popup.make("&Window"     ,0,   window);    Result.add(popup);
      !!popup.make("&Help"       ,0,   help);      Result.add(popup);

   end;

   ---------------------------------------------------- event
   --  This is a switch which responds to menu commands.
   on_event ( cmd : INTEGER ) : INTEGER is
   local
      file_editor     : FILE_EDIT_WINDOW,
      file_name       : STRING,
      f               : FORMAT,
      i,j             : INTEGER,
      area            : RECT;
      table           : TBL_ELEM;
      clc             : CALCULATOR;
      te              : TXE_ELEM;
      graphic         : GRAPHIC_ELEM;
      cell            : REAL_CELL;
      tv              : TV_ELEM;
   do
      Result := processed;

      inspect
         cmd
      when IDM_NEW then       -- Creates a new editor window
         !!f;
         !!file_name.adapt( "EPWL: Untitled" );
         file_name.append( f.i2s( "2", edit_count ) );

         !!file_editor.make_new( file_name );
         file_editor.set_save_dialog( save_dlg );

         desktop.add ( file_editor );
         edit_count := edit_count + 1;
         menu.enable_items( TRUE, <<IDM_SAVE, IDM_SAVEAS>>);
      when IDM_OPEN then            -- Open a file
         if execute( open_dlg ) > 0 then
            !!file_editor.open( open_dlg.selected_path );
            file_editor.set_save_dialog( save_dlg );
            desktop.add( file_editor );
         end; -- if

      when IDM_OPEN_MULTIPLE then
         if execute( open_multiple ) > 0 then
            from
               i := open_multiple.selected_files.lower
            until
               i > open_multiple.selected_files.upper
            loop
               file_name := fsystem.concat_paths( open_multiple.selected_path,
                  open_multiple.selected_files.item( i ) );
               j := message_box( file_name );
               !!file_editor.open( file_name );

               file_editor.set_save_dialog( save_dlg );
               desktop.add( file_editor );
               i := i + 1;
            end; -- loop
         end; -- if

      when IDM_TILE then            -- Standard desktop operations
         desktop.tile();
      when IDM_CASCADE then
         desktop.cascade();
      when IDM_ARRANGE then
         desktop.arrange();
      when IDM_CLOSE_ALL then
         desktop.wipe();
      when IDM_CLOSE then
         if desktop.get_current /= VOID then
             desktop.get_current.destroy();
         end; -- if

      when IDM_ABOUT then
         i := message_box (
                 "This demo application is a test program from%N%
                 %Eiffel Portable Windows Library,%N%N%
                 %Authors: Dmitry Mastrukov,%N%
                 %                Nicolas Abou Rjeily,%N%
                 %                Kirill Seitkhalilov.%N%N%
                 %Ulter Systems, Ltd. and Pulse Train Technology, Ltd, 1993.");


      when IDM_CALC then
         !!clc.make();
         i := execute ( clc );
      when IDM_NEWTABLE then
         !!f;
         !!file_name.adapt( "An Example Table N " );
         file_name.append( f.i2s( "2", table_count ) );
         !!table.make ( file_name );
         table.tbl.open_on( matrix );
         desktop.add ( table );
         table_count := table_count + 1;
      when IDM_NEWGRAPH then
         !!f;
         !!file_name.adapt( "A Simple Chart Window N " );
         file_name.append( f.i2s( "2", te_count ) );

--         !!matrix.make(3,15);
         matrix.protect;
         from i := 1; until i > matrix.rows; loop
            from j := 1; until j > matrix.columns; loop
               if j = 1 then -- the histogram
                  !!cell.make( (i+j)^2-100 );
               elseif j = 2 then
                  !!cell.make( (i+j)^2 - 150 );
               else
                  !!cell.make( 100 - (i+j)^2 );
               end; --
               matrix.put( cell, j, i );
               j := j + 1;
            end; -- loop
            i := i + 1;
         end; -- loop
         matrix.unprotect;

         !!graphic.make ( file_name );
         graphic.graphic.open_on( matrix );
         graphic.graphic.set_histogram_legend( "   Auditoria " );
         graphic.graphic.set_curves_legend( " Rate   " );
         desktop.add ( graphic );

         te_count := te_count + 1;
      when IDM_EDITGRAPH  then
         if matrix /= Void then
            from i := 1  until i > 10  loop
               from j := 0  until j > 100000  loop j := j + 1;
               end; -- loop
               !!cell.make( 20 * i );
               matrix.put( cell, 1, 4 );
               i := i + 1;
            end; -- loop
         end;
      when IDM_NEWTEXT then
         !!f;
         !!file_name.adapt( "A TXE Like Window N " );
         file_name.append( f.i2s( "2", te_count ) );

         !!te.make ( file_name );
         desktop.add ( te );
         te_count := te_count + 1;
      when IDM_NEWTREE then
         !!tv.make( "WIndow With Tree Viewer" );
         desktop.add ( tv );
      when IDM_QUIT then
         terminate();
      else
         Result := not_processed;
      end; -- inspect
   end; -- on_event

   ---------------------------------------------------- rbutton_down
   on_rbutton_down ( x : INTEGER, y : INTEGER) : INTEGER is
   do
      window.track( current, x, y );
   end; -- rbutton_down

invariant
end; -- DEMO_APP
