class TXE_ATTRIBUTE_DIALOG
inherit
   DIALOG
   rename
      make as dlg_make
   redefine
      set_data, on_clicked, on_double_clicked, on_changed
   select
      init, set_data, on_clicked, on_double_clicked, on_changed
   end;
creation
   make
feature
   OK, CANCEL, LBOX, FONT : INTEGER is UNIQUE;
   ----------------------------------------------------
   ok_b : TEXT_BUTTON;
   cn_b : TEXT_BUTTON;
   fn_b : TEXT_BUTTON;
   lb   : LIST_BOX;
   bg   : BUTTON_GROUP;
   ---------------------------------------------------- make
   make ( s : STRING ) is
   local
      r : RECT;
   do
      !!r.make ( 100, 100, 200, 200 );
      dlg_make ( s, r );
      --
      !!r.make ( 0.65, 0.05, 0.3, 0.9 );
      !!bg.make ( Void, r, VERTICAL, true, 0.3 );
      !!ok_b.make ( "Ok", null_rect, OK );
      bg.add ( ok_b );
--      !!cn_b.make ( "Cancel", null_rect, CANCEL );
--      bg.add ( cn_b );
      !!fn_b.make ( "Font", null_rect, FONT );
      bg.add ( fn_b );
      add ( bg );

      !!r.make ( 0.05, 0.05, 0.55, 0.9 );
      !!lb.make ( "Listbox", r, LBOX, false, false );
      add ( lb );
   end;
   ---------------------------------------------------- on_clicked
   on_clicked ( t : TILE ) : INTEGER is
   local
      s : STRING;
      i : INTEGER;
      p : POINTER;
      sc : STRING_COMPONENT;
   do
      result := not_processed;

      if t.context = CANCEL OR ELSE t.context = OK then
         terminate ( t.context );
         result := processed;
      elseif t.context = FONT then
         s := lb.get_current().contents_to_string()
         if s /= Void then
            attributes.search( s );
            if attributes.found then
               i := attributes.found_item.get_color;
               p := attributes.found_item.get_font;
               i := choose_font( p, i );
               attributes.found_item.set_color( i );
            end; -- if
         end; -- if
      end; -- if
   end;
   ---------------------------------------------------- on_double_clicked
   on_double_clicked ( l : LIST_BOX ) : INTEGER is
   local
      s : STRING;
   do
--      !!s.adapt ( l.name )
--      s.append ( " double clicked" );
      result := not_processed;
   end;
   ---------------------------------------------------- on_changed
   on_changed ( t : TILE ) : INTEGER is
   local
   do
   end;
   ---------------------------------------------------- set_data
   set_data() is
   local
      it : ITERATOR;
      sc : STRING_COMPONENT;
   do
      from
         it := attributes.iterator;
      until
         it.finished;
      loop
         !!sc.make (attributes.key( it ));
         lb.add( sc );
         it.forth;
      end; -- loop
      lb.set_current_pos( 1 );
      set_default_button ( ok_b );
--      set_cancel_button ( cn_b );
   end;
   --
   set_attributes( a : like attributes ) is
   do
      attributes := a; --clone( a );
   end;
   --
   attributes : SIMPLE_TABLE[ STRING, TEXT_TAG_FONT ];
   --
   choose_font( f : POINTER, c : INTEGER ) : INTEGER is
   require
      f /= Void;
   external
      "CWC" alias "text_ChooseFont"
   end;
end; -- TXE_ATTRIBUTE_DIALOG
