-- Copyright (c) 1993 by:
--    Ulter Systems Ltd.                  Pulse Train Technology Ltd.
--    77 Schelkovskoe Shosse              30 Alan Turing Road
--    107497 Moscow, Russia               Guilford, Surrey GU2 5AA, England
--    tel./fax +7095 460 4710             tel. +44 483 300 100
--                                        fax  +44 483 302 194
----------------------------------------------------------------------------
-- Name        : TXE_ELEM
-- ACN         :
-- Cluster     :
-- Test        :
-- Author      : Kirill_Seitkhalilov
-- Entered     : 03-09-93
-- Lines       :
----------------------------------------------------------------------------
-- Description :
----------------------------------------------------------------------------
class TXE_ELEM
inherit
   DESKTOP_ELEMENT
   rename
      make  as de_make,
   redefine
      on_event
   select
      init, on_event
   end;
   SYSTEM_COMMAND
   end;
creation
   make
feature
   ----------------------------------------------------
   text           : TEXT;
   memo           : V_MEMO;
   ---------------------------------------------------- make
   make ( t : STRING ) is
   local
      r              : RECT;
      s              : STRING;
      normal         : TEXT_TAG_FONT;
      italic         : TEXT_TAG_FONT;
      bold           : TEXT_TAG_FONT;
      bold_italic    : TEXT_TAG_FONT;
      st             : SYSTEM_TIME;
      months         : ARRAY[ STRING ];
      f              : FORMAT;
      day, month, year, today, x : STRING;
   do
      !!f;
      !!st;
      st.to_date( st.now );
      !!months.make( 1, 12 );
      months.put( "January"    ,  1 );
      months.put( "February"   ,  2 );
      months.put( "March"      ,  3 );
      months.put( "April"      ,  4 );
      months.put( "May"        ,  5 );
      months.put( "June"       ,  6 );
      months.put( "July"       ,  7 );
      months.put( "August"     ,  8 );
      months.put( "September"  ,  9 );
      months.put( "October"    ,  0 );
      months.put( "November"   , 11 );
      months.put( "December"   , 12 );

--      months := << "January", "February", "March", "April", "May", "June",
--                   "July", "August", "September", "October",
--                   "November", "December" >>;
      de_make ( t );
      --
      -- Scroll bars creation
      --
      !!s.make( 0 );
      s.append( "The day is today./!" );
      s.append( "This is a string with date /%%today.../!" );
      s.append( "/+BOLD This is a string in bold .../!" );
      s.append( "/+ITALIC This is a string in italic .../!" );
      s.append( "/+NORMAL This is a normal string.../!" );
      s.append( "/-This is a string after end of attributes escape " );
      s.append( "(it look like the previous one, doesn't it).../!" );
      s.append( "/!/+NORMAL Normal/+ITALIC Italic" );
      s.append( "/+BOLD Bold/+BITALIC BoldItalic/-" );

      !!r.make( 0.0, 0.5, 1.0, 0.5 );
      !!memo.make( s, r , 100);
      add( memo );

      !!r.make( 0.0, 0.0, 1.0, 0.5 );
      !!text.make( "Text panel",  r );


      !!bold.bold;
      bold.set_color( bold.red );
      !!normal.normal;
      normal.set_color( normal.gray );
      !!italic.italic;
      italic.set_color( italic.blue );
      !!bold_italic.bold_italic;
      bold_italic.set_color( bold_italic.black );

      day := f.i2s("3",st.day);
      x := months.item(st.month);
      !!month.adapt( x );
      year := f.i2s("5",st.year);
      !!today.adapt( day );
      today.append( " " );
      today.append( month );
      today.append( "," );
      today.append( year );

      !!specials.make( false );
         specials.add( day                  ,"DATE");
         specials.add( year                 ,"YEAR");
         specials.add( month                ,"MONTH");
         specials.add( today                ,"TODAY");
         specials.add( ""                   ,"T0");
         specials.add( ""                   ,"T1");
         specials.add( ""                   ,"T2");
         specials.add( ""                   ,"T3");
         specials.add( ""                   ,"T4");
         specials.add( ""                   ,"T5");
         specials.add( ""                   ,"T6");
         specials.add( ""                   ,"T7");
         specials.add( ""                   ,"T8");
         specials.add( ""                   ,"T9");

      !!attributes.make( false );
         attributes.add( bold              ,"BOLD");
         attributes.add( italic            ,"ITALIC");
         attributes.add( normal            ,"NORMAL");
         attributes.add( bold_italic       ,"BITALIC");

      !!alternatives.make( false );

      text.set_specials( specials );
      text.set_attributes( attributes );
      text.set_alternatives( alternatives );
      text.set_text( s );
      text.parse;

      add( text );

   end;
   ---------------------------------------------------- event
   on_event ( cmd : INTEGER ) : INTEGER is
   local b : BOOLEAN, i : INTEGER; s : STRING;
      rc : RECT; f : FORMAT;
      spec_dlg : TXE_SPECIAL_DIALOG;
      attr_dlg : TXE_ATTRIBUTE_DIALOG;
   do
      result := processed;

      inspect
         cmd
      when IDM_HL     then   text.set_h_left;    text.update;
      when IDM_HC     then   text.set_h_center;  text.update;
      when IDM_HR     then   text.set_h_right;   text.update;
      when IDM_VT     then   text.set_v_top;     text.update;
      when IDM_VC     then   text.set_v_center;  text.update;
      when IDM_VB     then   text.set_v_bottom;  text.update;
      when IDM_TEXT   then
         if memo.is_modified  then
            !!s.make( 0 );
            from i := 1 until i >= memo.get_line_count + 1 loop
--               dummy := message_box( memo.get_line( i ) );
               s.append( memo.get_line( i ) );
               i := i + 1;
            end;
            text.set_text( s );
	    text.parse;
            text.update;
            memo.set_modified( false );
         end; -- if
      when IDM_SPEC then
         !!spec_dlg.make( "Set special text strings" );
         spec_dlg.set_specials( specials  );
         if execute( spec_dlg ) = spec_dlg.OK then
            specials := spec_dlg.specials;
            text.set_specials( specials );
            text.parse;
            text.update;
         end;
      when IDM_SIZE  then
         rc := text.get_text_rect;
         if rc /= Void  then
            !!f;
            !!s.adapt( "Bounding rectangle for text(pixels)%N" );
            s.append( "width ");
            s.append( f.i2s( "5.2", rc.w ) );
            s.append( " height");
            s.append( f.i2s( "5.2", rc.h ) );
            dummy := message_box( s );
         end; -- if
      when IDM_ATTR then
         !!attr_dlg.make( "Set attributes for text drawing" );
         attr_dlg.set_attributes( attributes  );
         if execute( attr_dlg ) = attr_dlg.OK then
--            attributes := attr_dlg.attributes;
--            text.set_attributes( attributes );
            text.parse;
            text.update;
         end;

    --
    -- This is a standard for unprocessed messages
    --
      else
       result := not_processed;
      end; -- inspect
   end;

--feature { NONE }
   dummy          : INTEGER;
   attributes     : SIMPLE_TABLE[ STRING, TEXT_TAG_FONT ];
   specials       : SIMPLE_TABLE[ STRING, STRING ];
   alternatives   : SIMPLE_TABLE[ STRING, STRING ];

end; -- TXE_ELEM
