class TXE_SPECIAL_DIALOG
inherit
   DIALOG
   rename
      make as dlg_make
   redefine
      set_data, on_clicked, on_double_clicked, on_changed
   select
      init, set_data, on_clicked, on_double_clicked, on_changed
   end;
creation
   make
feature
   OK, CANCEL, LBOX, ENTRY : INTEGER is UNIQUE;
   ----------------------------------------------------
   ok_b : TEXT_BUTTON;
   cn_b : TEXT_BUTTON;
   lb : LIST_BOX;
   te : TEXT_LINE_ENTRY;
   bg : BUTTON_GROUP;
   ---------------------------------------------------- make
   make ( s : STRING ) is
   local
      r : RECT;
   do
      !!r.make ( 100, 100, 200, 200 );
      dlg_make ( s, r );
      --
      !!r.make ( 0.65, 0.05, 0.3, 0.3 );
      !!bg.make ( Void, r, VERTICAL, true, 0.3 );
      !!ok_b.make ( "Ok", null_rect, OK );
      bg.add ( ok_b );
      !!cn_b.make ( "Cancel", null_rect, CANCEL );
      bg.add ( cn_b );
      add ( bg );

      !!r.make ( 0.05, 0.7, 0.9, 0.15 );
      !!te.make ( "Line entry", r, 0 );
      add ( te );

      !!r.make ( 0.05, 0.05, 0.55, 0.65 );
      !!lb.make ( "Listbox", r, LBOX, false, false );
      add ( lb );
   end;
   ---------------------------------------------------- on_clicked
   on_clicked ( t : TILE ) : INTEGER is
   local
   do
      result := not_processed;

      if t.context = CANCEL OR ELSE t.context = OK then
         terminate ( t.context );
         result := processed;
      else

      end; -- if
   end;
   ---------------------------------------------------- on_double_clicked
   on_double_clicked ( l : LIST_BOX ) : INTEGER is
   local
      s : STRING;
   do
--      !!s.adapt ( l.name )
--      s.append ( " double clicked" );
--      result := not_processed;
   end;
   ---------------------------------------------------- on_changed
   on_changed ( t : TILE ) : INTEGER is
   local
      s : STRING;
      i : INTEGER;
   do
      if t /= Void AND THEN t = te  then
         if
            lb /= Void AND THEN lb.get_current() /= Void AND THEN
            NOT lb.get_current().contents_to_string().empty 
            AND THEN specials /= Void
         then
            s := te.get_text();
            if s /= Void AND THEN NOT s.empty  then
               specials.replace( s, lb.get_current().contents_to_string() );
            end; -- if
         end; -- if
      elseif t /= Void AND THEN t = lb AND THEN lb.get_current /= Void then
         specials.search( lb.get_current().contents_to_string() );
         if specials.found then
            te.set_text( specials.found_item );
         else
            te.set_text( "" );
         end; -- if
      end; -- if
   end;
   ---------------------------------------------------- set_data
   set_data() is
   local
      it : ITERATOR;
      sc : STRING_COMPONENT;
   do
      from
         it := specials.iterator;
      until
         it.finished;
      loop
         !!sc.make ( specials.key( it ) );
         lb.add( sc );
         it.forth;
      end; -- loop
      lb.set_current_pos( 1 );
      specials.search( lb.get_component( 1 ).contents_to_string() );
      if specials.found then
         te.set_text( specials.found_item );
      else
         te.set_text( "" );
      end; -- if
      set_default_button ( ok_b );
      set_cancel_button ( cn_b );
   end;
   --
   set_specials( st : like specials ) is
   do
      specials := st; -- clone( st );
   end;
   --
   specials : SIMPLE_TABLE[ STRING, STRING ];
end; -- TXE_SPECIAL_DIALOG

