/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/tools/sources/RCS/mkpat.c,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.1

  PURPOSE        : convert 8 bit raw file to snns pattern entry
  NOTES          :

  AUTHOR         : Ralf Huebner 
  DATE           : 2.4.93

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.4 $
  LAST CHANGE    : $Date: 1995/11/16 07:21:42 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include <stdio.h>
#ifndef WIN32
#include <malloc.h>
#endif

#define RAWNUM 8

int main(int argc, char *argv[])

{
   int i;
   float out_val;
   unsigned xsize, ysize;
   unsigned char *buffer, *ptr, *limit;

   if ((argc!=3) || (int) strcmp(*++argv, "-h")==0 ) {
      fprintf (stderr, "convert 8 bit raw file to snns pattern entry\n\n");
      fprintf (stderr, "  usage: mkpat <xsize> <ysize>\n\n");
      exit(0);
   }
   xsize = atol(*argv);
   ysize = atol(*++argv);

   if ( (buffer=(unsigned char *)malloc(xsize*ysize) ) == NULL) {
       fprintf (stderr, "ERROR: Can`t allocate memory\n");
       exit(-1);
   }
   if ((unsigned char *)fread(buffer, xsize*ysize, 1, stdin) == NULL) {
       fprintf (stderr, "ERROR: Can`t read from stdin\n");
       exit(-1);
   }
   
   i = 0;
   limit = buffer + xsize*ysize;
   
   for(ptr=buffer; ptr<limit; ptr++) {
      out_val = ((float) *ptr) / 255.0;
      if ( ((i % xsize == 0) || (i % RAWNUM == 0)) && (i != 0) )
          printf("\n");
      i++;
      printf ("%.3f ", out_val);
   }
  printf ("\n");
  free(buffer);
  return 0;
}
   
