int view_average_port(int port,int samples)
{
  int i,accum;

  printf("Press button to average\n");
  sleep(.7);

  while(chosen_button()==NEITHER_B)
    {
      printf("Port %d=%d\n",port,analog(port));
      sleep(.1);
    }
  if(chosen_button()==ESCAPE_B)
    return(-1);

  for(i=0;i<samples;i++)
    accum+=analog(port);
  
  samples=(accum/samples);
  printf("Port %d average=%d\n",port,samples);
  return(samples);
}


void view_inputs()
{
  char a[]="1.1 View Analog Port\n1.2 View DigitalPort\n1.3 View Frob   Knob\n1.4 View Dip    Switches\n1.5 View Motor  Force\n1.6 View IR\n1.7 Go Back";
  int sel,port,index;
  
  while(1)
    {
      index=select_string(a,7);
      if(index==-1 || index>5)
	return;

      if(index==0)  /* analog */
	{
	  while(chosen_button()==NEITHER_B)
	    {
	      int port=(((frob_knob()*27)/255) + 8);
	      printf("analog(%d) = %d\n",port,analog(port));
	      sleep(.1);
	    }
	  wait_button(UP_B);
	}
      else if(index==1) /* digital */
	{
	  while(chosen_button()==NEITHER_B)
	    {
	      int port=((frob_knob()*35)/255);
	      printf("digital(%d) = %d\n",port,digital(port));
	      sleep(.1);
	    }
	  wait_button(UP_B);
	}
      else if(index==2) /* frob knob */
	{
	  while(chosen_button()==NEITHER_B)
	    {
	      printf("frob_knob()=%d\n",frob_knob());
	      msleep(50L);
	    }
	  wait_button(UP_B);
	}
      else if(index==3) /* dip switches */
	{
	  while(chosen_button()==NEITHER_B)
	    {
	      printf("dip_switches()= %b\n",dip_switches());
	      sleep(.4);
	    }
	  wait_button(UP_B);
	}
      else if(index==4)  /* motor force */
	{
	  while(1) {
	    while(chosen_button()==NEITHER_B)
	      {
		int port=(frob_knob()*7)/255;
		if(port>5)
		  printf("1.5.6 Go Back\n");
		else
		  printf("1.5.%d View Motor %d\n",port,port);
		msleep(60L);
	      }
	    if(port>5 || chosen_button()==ESCAPE_B)
	      break;
	    
	    printf("motor(%d,100)\n",port);
	    motor(port,100);
	    sleep(.7);
	    
	    while(chosen_button()==NEITHER_B)
	      {
		printf("motor_force(%d)=%d\n",port,motor_force(port));
		sleep(.1);
	      }
	    printf("motor(%d,0)\n",port);
	    motor(port,0);
	    sleep(.7);
	  }
	}
      else if(index==5)		/* IR input */
	{
	  printf("ir_receive_on()\n");
	  ir_receive_on();
	  sleep(.7);

	  while(1) {
	    int freq,port;
	    char ch[]="1.6.1 Choose 100Hz\n1.6.2 Choose 125Hz\n1.6.3 Go Back";
	    
	    freq=select_string(ch,3);
	    if(freq==-1 || freq>1)
	      break;
	    else if(freq==0)
	      {
		printf("set_ir_receive_frequency(100)\n");
		set_ir_receive_frequency(100);
		sleep(.7);
	      }
	    else if(freq==1)
	      {
		printf("set_ir_receive_frequency(125)\n");
		set_ir_receive_frequency(125);
		sleep(.7);
	      }
	    
	    while(1) {
	      while(chosen_button()==NEITHER_B)
		{
		  port=((frob_knob()*5))/255+4;
		  if(port>7)
		    printf("1.6.%d.8 Go Back\n",freq);
		  else
		    printf("1.6.%d.%d IR in   port %d\n",freq,port,port);
		  msleep(50L);
		}
	      if(chosen_button()==ESCAPE_B || port>7)
		break;
	      wait_button(UP_B);
	      
	      while(chosen_button()==NEITHER_B)
		{
		  printf("ir_counts(%d)=%d\n",port,ir_counts(port));
		  msleep(50L);
		}
	      wait_button(UP_B);
	    }
	  }
	  printf("ir_receive_off()\n");
	  ir_receive_off();
	  sleep(.7);
	}
      else  /* Quit */
	return;
      wait_button(UP_B);
    }
}

void frob_outputs()
{
  char a[]="2.1 Frob Motors\n2.2 Frob LEDs\n2.3 Frob Servo\n2.4 Frob IR\n2.5 Go back";
  int sel,port,index;

  while(1)
    {
      index=select_string(a,5);
      if(index==-1 || index==4)
	return;
      if(index==0) /* motors */
	while(1)
	  {
	    while(chosen_button()==NEITHER_B)
	      {
		int port=(frob_knob()*7)/255;
		if(port>5)
		  printf("2.1.6 Go Back\n");
		else
		  printf("2.1.%d Frob Motor %d\n",port,port);
		msleep(60L);
	      }
	    if(chosen_button()==ESCAPE_B)
	      break;
	    wait_button(UP_B);

	    while(chosen_button()==NEITHER_B)
	      {
		sel=frob_knob()-128;
		if(sel>100)
		  sel=100;
		else if(sel<-100)
		  sel=-100;
		printf("motor(%d,%d)\n",port,sel);
		motor(port,sel);
		msleep(40L);
	      }
	    printf("off(%d)\n",port);
	    off(port);
	    sleep(.7);
	  }
      else if(index==1)  /* LEDS */
	{
	  char ch[]="2.2.1 Turn Led 0 on\n2.2.2 Turn Led 0 off\n2.2.3 Turn Led 1 on\n2.2.4 Turn Led 1 off\n2.2.5 Go Back";
	  while(1)
	    {
	      sel=select_string(ch,5);
	      if(sel==-1 || sel==4)
		break;
	      if(sel==0) 
		{
		  printf("led_out0(1)\n");
		  led_out0(1);
		  sleep(.7);
		}
	      else if(sel==1) 
		{
		  printf("led_out0(0)\n");
		  led_out0(0);
		  sleep(.7);
		}
	      else if(sel==2)
		{
		  printf("led_out1(1)\n");
		  led_out1(1);
		  sleep(.7);
		}		  
	      else if(sel==3) 
		{
		  printf("led_out1(0)\n");
		  led_out1(0);
		  sleep(.7);
		}
	      else
		return;
	    }		
	  wait_button(UP_B);
	}  
      else if(index==2) /* servo */
	{
	  printf("servo_on()\n");
	  servo_on();
	  sleep(.7);
	  while(chosen_button()==NEITHER_B)
	    {
	      sel=(frob_knob()*10)+700;
	      printf("servo(%d)\n",sel);
	      servo(sel);
	      msleep(40L);
	    }
	  printf("servo_off()\n");
	  servo_off();
	  sleep(.7);
	  wait_button(UP_B);
	}
      else if(index==3) /* Frob IR */
	{
	  char ch[]="2.4.1 Turn IR   on\n2.4.2 Set IR    100Hz\n2.2.3 Set IR    125Hz\n2.2.4 Turn IR   off\n2.2.5 Go Back";
	  while(1) {
	    sel=select_string(ch,5);
	    if(sel==-1 || sel==4)
	      break;
	    if(sel==0){
	      printf("ir_transmit_on()\n");
	      ir_transmit_on();
	      sleep(.7);
	    }
	    else if(sel==1)
	      {
		printf("set_ir_transmit_frequency(100)\n");
		set_ir_transmit_frequency(100);
		sleep(.7);
	      }
	    else if(sel==2)
	      {
		printf("set_ir_transmit_frequency(125)\n");
		set_ir_transmit_frequency(125);
		sleep(.7);
	      }
	    else if(sel==3) /* IR off */
	      {
		printf("ir_transmit_off()\n");
		ir_transmit_off();
		sleep(.7);
	      }
	  }
	}
      wait_button(UP_B);
    }
}

int control_choose()
{
  char a[]="1. View Inputs\n2. Frob outputs\n3. Quit";
  return(select_string(a,3));
}

void control_panel()
{
  int index;

  while(1)
    {
      if((index=control_choose())==-1)
	return;
      
      if(index==0) /* view inputs */
	view_inputs();
      else if(index==1) /* frob outputs */
	frob_outputs();
      else /* Quit */
	return;
    }
  printf("Diagnostic Done\n");
}

void main()
{
  control_panel();
}
