/*  contest code  for starting and stopping machines  */

/*************************************/
/*** Starting and Stopping Machine ***/
/*************************************/

/* call with analog port number of light sensor
   used to detect starting lamp */

void start_machine(int port)
{
    int on_value, off_value, trigger_value;

    /* 
      STEP 1.  Choose IR frequencies and goal based on DIP switch 1
    */
    while (!escape_button()){
      if (dip_switch(1)) {
	/* DIP_SWITCH(1) = 1 */
	/* +45deg polarization */
	printf("Xmit CLEAR      ESC to continue\n");
	ir_xmit_period= 10000;          /* Transmit at 100 Hz */
	ir_freq_rcv_select= 125;        /* Recieve 125 Hz */
      } 
      else {
	/* DIP_SWITCH(1) = 0 */
	/* -45deg polarization */
	printf("Xmit GREEN      ESC to continue\n");
	ir_xmit_period= 8000;           /* Transmit at 125 Hz */
	ir_freq_rcv_select= 100;        /* Recieve 100 Hz */
      }
      sleep(.2);
    }
    while (escape_button());

    /*
      STEP 2.  Wait for user to press choose button, indicating
      that machine is positioned over starting lamp (which is on).
    */

    while (!choose_button()) {
	printf("%d when ON       Press CHOOSE\n", analog(port));
	sleep(0.15); /* delay helps printf's look nice */
    }

    on_value= _average_analog_sensor(port, 20);  /* take 20 samples */

    while (choose_button());  /* wait for user to release button */


    /* 
      STEP 3.  Wait for user to press choose button, indicating
      that machine is positioned over starting lamp (which is off).
    */

    while (!choose_button()) {
	printf("%d when OFF     Press CHOOSE\n", analog(port));
	sleep(0.15); /* delay helps printf's look nice */
    }

    off_value= _average_analog_sensor(port, 20);  /* take 20 samples */

    while (choose_button());  /* wait for user to release button */


    /*
      STEP 4.  Compute mid-range value.  Wait for an averaged sample
      to fall below that value; then start machine.
     */

    trigger_value= (on_value + off_value) / 2;

    while (_average_analog_sensor(port, 6) > trigger_value) {
	printf("%d waiting for %d\n", analog(port), trigger_value);
	sleep(0.02);  /* a little delay for LCD readability */
    }

    /*
      STEP 5.  Enable start.
    */

    printf("G O  !!! \n");

    reset_system_time();
    ir_transmit_on();			       /* turn on IR */
    start_process(_stop_machine(60.), 1, 100);  /* give it one tick */
/*    start_countdown(60000);*/
}

int _average_analog_sensor(int port, int samples)
{
    int i, sum=0;

    for (i= 0; i< samples; i++)
      sum += analog(port);

    return sum/samples;
}

/*  hogs processor when time is up  */
void _stop_machine(float time)
{
    while (seconds() < time);

    ir_transmit_off();	/* turn off IR */
    while (1) {
	hog_processor();
	alloff();
	servo_off();
	beeper_off();
	/*  add your own commands to turn off other motors here  */
    }

}





