/*
 * @(#)ExceptionFrame.java	1.0alpha (18 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.espresso.debug;

import java.awt.*;
import sun.tools.debug.*;

/**
 * A dialog window for dealing with exception events
 *
 * @version	1.0beta (27 Nov 1995)
 * @author	Ted Phelps
 */

class ExceptionFrame extends Frame
{
    /** The Debugger that spawned us */
    Debugger debugger;

    /** The thread which encountered the exception */
    RemoteThread thread;

    /** The error message accompanying the exception event */
    String error;

    /** Constructs a new exception dialog */
    public ExceptionFrame(Debugger debugger, RemoteThread thread, String error)
    {
	this.debugger = debugger;
	this.thread = thread;
	this.error = error;

	initializeFrame();
    }

    /** Places widgets in a new dialog */
    private void initializeFrame()
    {
	TextArea text;
	Panel panel;

//	setTitle("Exception");
	setTitle(getExceptionClassName());

	setLayout(new BorderLayout());
	text = new TextArea(error);
	text.setEditable(false);
	add("Center", text);

	panel = new Panel();
	panel.add(new Button("Continue"));
	panel.add(new Button("Debug"));
	panel.add(new Button("Ignore"));
	add("South", panel);
	pack();
    }

    /** If the thread is suspended or at a breakpoint */
    public boolean isSuspended() throws Exception
    {
	String status = thread.getStatus();
	return status.equals("suspended") || status.equals("at breakpoint");
    }


    /** Returns the class name of the exception */
    public String getExceptionClassName()
    {
	return error.substring(error.indexOf(": ") + 2, error.indexOf('\t'));
    }

    /** Returns the exception's remote class */
    public RemoteClass getExceptionClass() throws Exception
    {
	return debugger.debugger.findClass(getExceptionClassName());
    }


    /** Handles button events */
    public boolean action(Event event, Object target)
    {
	try
	{
	    if (target.equals("Continue"))
	    {
		// Make sure the thread is still suspended
		if (isSuspended())
		{
		    thread.cont();
		    this.hide();

		    debugger.pollManager.sync();
		}

		return true;
	    }

	    if (target.equals("Debug"))
	    {
		ThreadBrowser.on(debugger, thread).show();
		this.hide();

		debugger.pollManager.sync();
		return true;
	    }

	    if (target.equals("Ignore"))
	    {
		getExceptionClass().ignoreExceptions();
		thread.cont();
		this.hide();

		debugger.pollManager.sync();
		return true;
	    }
	}
	catch (Exception exception)
	{
	    exception.printStackTrace();
	}

	return super.action(event, target);
    }
}
