/*
 * @(#)RemoteStackFrameInspector.java	1.0alpha (18 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.espresso.debug;

import sun.tools.debug.*;
import dstc.espresso.inspect.*;

/** 
 * A special inspector for looking at stack frames
 *
 * @version	1.0alpha (26 Oct 1995)
 * @author	Ted Phelps
 */

public class RemoteStackFrameInspector extends Inspector
{
    RemoteStackVariable target[];
    RemoteField fields[];

    /** Constructs a new inspector on the array of stack variables */
    public RemoteStackFrameInspector(Object t)
    {
	target = (RemoteStackVariable [])t;
    }

    /** Returns a string representing the name of the class */
    public String getClassName()
    {
	return "StackFrame";
    }


    /** Returns a string representing the target of this inspector */
    public String getTarget()
    {
	return target.toString();
    }


    /**
     * Returns an array of strings representing the names of
     * the instance variables, etc of the object
     */
    public String[] getNames()
    {
	String names[] = new String[target.length];

	for (int i = 0; i < target.length; i++)
	{
	    if (target[i].inScope())
	    {
		names[i] = target[i].getName();
	    }
	    else
	    {
		// FIX THIS? would prefer to just gray these instead...
		names[i] = "[" + target[i].getName() + "]";
	    }
	}

	return names;
    }


    /**
     * Returns a string which represents the object named
     * by the getNames value indexed by the int
     */
    public String getValue(int index)
    {
	if (target[index].inScope())
	{
	    return String.valueOf(target[index].getValue());
	}

	return "[not in scope]";
    }


    /** Returns an Inspector on the object indexed by the int */
    public Inspector getInspector(int index)
    {
	if (target[index].inScope())
	{
	    return Inspector.on(target[index].getValue());
	}

	return null;
    }
}
