/*
 * @(#)RemoteObjectInspector.java	1.0alpha (17 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.espresso.inspect;

import sun.tools.debug.*;

/** 
 * An inspector on a remote object
 *
 * @see		dstc.espresso.inspect.Inspector
 * @version	1.0alpha (17 Oct 1995)
 * @author	Ted Phelps
 */
public class RemoteObjectInspector extends Inspector
{
    /** The object being inspected */
    private RemoteObject target;

    /** The names of the fields of the object */
    private RemoteField fields[];

    /** Constructs a new Inspector on the object */
    public RemoteObjectInspector(Object t)
    {
	target = (RemoteObject)t;

	try
	{
	    fields = target.getFields();
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	}
    }

    /** Returns the name of the target's class */
    public String getClassName()
    {
	try
	{
	    RemoteClass c = target.getClazz();
	    if (c == null)
	    {
		return "null";
	    }
	    else
	    {
		return target.getClazz().getName();
	    }
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return "<error>";
	}
    }


    /** Returns a string representing the target */
    public String getTarget()
    {
	return target.toString();
    }


    /** eam.readInt());

     * Returns an array of strings representing the names of the
     * instance variables of the target
     */
    public String[] getNames()
    {
	String names[] = new String[fields.length];

	for (int i = 0; i < fields.length; i++)
	{
	    names[i] = fields[i].getName();
	}

	return names;
    }


    /**
     * Return a string representing the indexed instance variable of
     * the target 
     */
    public String getValue(int index)
    {
	try
	{
	    return String.valueOf(target.getFieldValue(index));
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return "<error>";
	}
    }


    /**
     * Returns a new Inspector on the indexed instance variable of the
     * target 
     */
    public Inspector getInspector(int index)
    {
	try
	{
	    return Inspector.on(target.getFieldValue(index));
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return null;
	}
    }
}
