/*
 * @(#)Debugger.java	1.0alpha (18 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.espresso.util;
import java.util.*;
import java.io.*;

/** 
 * A string which retains line number information
 *
 * @version	1.0alpha (26 Oct 1995)
 * @author	Ted Phelps
 */
public class IndexedString extends Object
{
    /** The target string */
    public String string;

    /** Translates between line numbers and character offsets */
    int indicies[];
    
    /** Constructs a new indexed string on the given string */
    public IndexedString(String s)
    {
	string = s;
    }

    /** Constructs a new indexed string on the given stream */
    public IndexedString(InputStream stream) throws IOException
    {
	byte buffer[];

	buffer = new byte[stream.available()];
	stream.read(buffer);
	string = new String(buffer, 0);
    }

    /** Returns an array of the starts of each line in the String */
    public int[] getIndicies()
    {
	if (indicies == null)
	{
	    Vector nums = new Vector();
	    int i = 0;

	    do
	    {
		nums.addElement(new Integer(i));
		i = string.indexOf('\n', i) + 1;
	    } while (i != 0);
	    nums.addElement(new Integer(string.length()));

	    indicies = new int[nums.size()];
	    for (i = 0; i < nums.size(); i++)
	    {
		Integer value = (Integer)nums.elementAt(i);
		indicies[i] = value.intValue();
	    }
	}

	return indicies;
    }


    /** Returns the number of lines of text in the String */
    public int numberOfLines()
    {
	return getIndicies().length - 1;
    }


    /** Returns the index of the start of the indicated line */
    public int startOfLine(int lineNumber)
    {
	return getIndicies()[lineNumber];
    }

    /** Returns the index of the end of the indicated line */
    public int endOfLine(int lineNumber)
    {
	return getIndicies()[lineNumber + 1];
    }

    /** Returns a string containing the indicated line */
    public String getLine(int lineNumber)
    {
	return string.substring(startOfLine(lineNumber), endOfLine(lineNumber));
    }

    /** Returns the target string */
    public String toString()
    {
	return string;
    }
}
