/*
 * @(#)Main.java	(2 Jan 1996)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995, 1996.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.debug;

import sun.tools.debug.*;

/**
 * Starts up the debugger
 *
 * @version 1.0a
 * @author Ted Phelps
 */
public class Main extends Object
{
    /** Parses input arguments and starts up the debugger frame */
    public static void main(String args[])
    {
	String hostname = null;
	String password = null;
	String classArgs[] = null;

	int i = 0;
	while (i < args.length)
	{
	    if (args[i].charAt(0) == '-')
	    {
		String param = args[i++].substring(1);

		if ("host".equals(param))
		{
		    if (i < args.length)
		    {
			hostname = args[i++];
		    }
		    else
		    {
			System.out.println("*** No hostname provided");
			System.exit(0);
		    }
		}

		if ("password".equals(param))
		{
		    if (i < args.length)
		    {
			password = args[i++];
		    }
		    else
		    {
			System.out.println("*** No password provided");
			System.exit(0);
		    }
		}
	    }
	    else
	    {
		classArgs = new String[args.length - i];
		for (int j = 0; j < classArgs.length; j++)
		{
		    classArgs[j] = args[i++];
		}
	    }
	}

	try
	{
	    if (password != null)
	    {
		if (hostname != null)
		{
		    new Debugger(hostname, password);
		}
		else
		{
		    new Debugger(password);
		}
	    }
	    else
	    {
		Debugger debugger = new Debugger();

		// Load requested class
		if (classArgs != null && classArgs.length > 0)
		{
		    debugger.args = classArgs;
		    debugger.loadClass(classArgs[0]);
		}
	    }
	}

	catch (Exception e)
	{
	    System.out.println("***");
	    e.printStackTrace();
	}
    }
}
