/*
 * @(#)PollManager.java	1.0alpha (18 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.debug;

import java.util.*;

/** 
 * Provide a periodic, resynchable polling mechanism
 *
 * @version	1.0alpha (18 Oct 1995)
 * @author	Ted Phelps
 */
public class PollManager extends Thread
{
    protected long period;
    protected Vector clients;
    protected Thread thread;

    /** Constructs a poll manager with the given period (in ms) between polls */
    public PollManager(long p)
    {
	super();

	period = p;
	clients = new Vector();
	setPriority(4);
	setName("Poll Manager");
    }

    /** Refreshs each of the clients */
    protected synchronized void refresh()
    {
	Enumeration c = clients.elements();

	while (c.hasMoreElements())
	{
	    ((PollCallback)c.nextElement()).pollEvent();
	}
    }


    /** Adds a client */
    public void addClient(PollCallback client)
    {
	clients.addElement(client);
	sync();
    }

    /** Remotes a client */
    public boolean removeClient(PollCallback client)
    {
	return clients.removeElement(client);
    }

    /** Poll all clients NOW! */
    public synchronized void sync()
    {
	notify();
    }

    /** Kill time until the period expires or we get notified */
    private synchronized void bideTime()
    {
	try
	{
	    wait(period);
	}
	catch (InterruptedException e)
	{
	    System.out.println("Interrupted");
	}
    }


    /** poll and wait loop */
    public void run()
    {
	while (true)
	{
	    refresh();
	    bideTime();
	}
    }
}



