/*
 * @(#)Inspector.java	1.0alpha (17 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.inspect;

import sun.tools.debug.*;

/** 
 * An abstract class for accessing the contents of an object
 *
 * @see		dstc.kalimantan.inspect.InspectorPanel
 * @see		dstc.kalimantan.inspect.InspectorFrame
 * @version	1.0alpha (17 Oct 1995)
 * @author	Ted Phelps
 */

public abstract class Inspector extends Object
{
    /** Constructs a new inspector on the object */
    public static Inspector on(Object object)
    {
	if (object == null)
	{
	    return new BoringInspector("null", "null");
	}

	if (object instanceof RemoteArray)
	{
	    return new RemoteArrayInspector(object);
	}

	if (object instanceof RemoteObject)
	{
	    return new RemoteObjectInspector(object);
	}

	if (object instanceof RemoteValue)
	{
	    return new RemoteValueInspector(object);
	}

	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return null;
	}
    }

    /** Constructs a new inspector on the boolean */
    public static Inspector on(boolean object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the byte */
    public static Inspector on(byte object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the char */
    public static Inspector on(char object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the short */
    public static Inspector on(short object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the int */
    public static Inspector on(int object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the long */
    public static Inspector on(long object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the float */
    public static Inspector on(float object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Constructs a new inspector on the double */
    public static Inspector on(double object)
    {
	try
	{
	    return Inspector.on(sun.tools.debug.Hack.getInstance().asRemoteValue(object));
	}
	catch (Exception e)
	{
	    return null;
	}
    }

    /** Returns the name of the target's class */
    public abstract String getClassName();


    /** Returns a string representing the target */
    public abstract String getTarget();

    /** 
     * Returns an array of strings representing the names of the
     * instance variables or array indices of the target
     */
    public abstract String[] getNames();

    /**
     * Return a string representing the indexed instance variable or
     * array element of the target
     */
    public abstract String getValue(int index);

    /**
     * Returns a new Inspector on the indexed instance variable or
     * array element of the target
     */
    public abstract Inspector getInspector(int index);
}
