/*
 * @(#)InspectorFrame.java	1.0alpha (17 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.inspect;

import java.awt.*;
import java.io.*;
import java.util.*;

/** 
 * A Frame for displaying an InspectorPanel and associated buttons
 *
 * @see		dstc.kalimantan.inspect.Inspector
 * @see		dstc.kalimantan.inspect.InspectorPanel
 * @version	1.0alpha (17 Oct 1995)
 * @author	Ted Phelps
 */
public class InspectorFrame extends Frame
{
    /** the inspector panel to be displayed */
    private InspectorPanel inspectorPanel;


    /** Returns an InspectorFrame on the object */
    public static InspectorFrame on(Object object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the boolean */
    public static InspectorFrame on(boolean object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the byte */
    public static InspectorFrame on(byte object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the char */
    public static InspectorFrame on(char object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the short */
    public static InspectorFrame on(short object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the int */
    public static InspectorFrame on(int object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the long */
    public static InspectorFrame on(long object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the float */
    public static InspectorFrame on(float object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Returns an InspectorFrame on the double */
    public static InspectorFrame on(double object)
    {
	return new InspectorFrame(InspectorPanel.on(object));
    }

    /** Constructs an InpectorFrame around the given InspectorPanel */
    public InspectorFrame(InspectorPanel p)
    {
	Panel panel;

	inspectorPanel = p;
	add("Center", inspectorPanel);

	panel = new Panel();
	panel.setLayout(new GridLayout(1, 4));
	panel.add(new Button("Back"));
	panel.add(new Button("Forward"));
	panel.add(new Button("Spawn"));
	panel.add(new Button("Close"));

	add("South", panel);
	pack();
	resize(310, 230);
	updateTitle();
	show();
    }


    /** Updates the Frame's title to reflect a new target */
    public void updateTitle()
    {
	setTitle(inspectorPanel.getTitle());
    }

    /** Closes the frame */
    public void close()
    {
//	hide();
	dispose();
    }

    /** Handles Window manager requests */
    public boolean handleEvent(Event event)
    {
	switch (event.id)
	{
	    case Event.WINDOW_DESTROY:
		close();
		return true;

	    default:
		return super.handleEvent(event);
	}
    }


    /** Handles button presses */
    public boolean action(Event event, Object target)
    {
	if (event.arg == "Back")
	{
	    inspectorPanel.pop();
	    updateTitle();
	    return true;
	}

	if (event.arg == "Forward")
	{
	    inspectorPanel.push();
	    updateTitle();
	    return true;
	}

	if (event.arg == "Close")
	{
	    close();
	    return true;
	}

	if (event.arg == "Spawn")
	{
	    (new InspectorFrame(inspectorPanel.spawn())).show();
	    return true;
	}

	return super.action(event, target);
    }
}
