/*
 * @(#)RemoteArrayInspector.java	1.0alpha (17 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.inspect;

import sun.tools.debug.*;

/** 
 * An inspector on a remote object
 *
 * @see		dstc.kalimantan.inspect.Inspector
 * @version	1.0alpha (17 Oct 1995)
 * @author	Ted Phelps
 */
public class RemoteArrayInspector extends Inspector
{
    /** the object being inspected */
    private RemoteArray target;

    /** the type of the elements of the array */
    private int elementType;

    /** the number of elements in the array */
    private int length;

    /** Constructs a new RemoteArrayInspector on the object */
    RemoteArrayInspector(Object t)
    {
	target = (RemoteArray)t;
	try
	{
	    elementType = target.getElementType();
	    length = target.getSize();
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	}
    }

    /** Returns the name of the target's class */
    public String getClassName()
    {
	try
	{
	    return "Array of " + target.arrayTypeName(elementType);
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return "<error>";
	}
    }


    /** Returns a string representing the target */
    public String getTarget()
    {
	return target.toString();
    }


    /** 
     * Returns an array of strings representing the names of the
     * indices of the target array
     */
    public String[] getNames()
    {
	String names[] = new String[length];

	for (int i = 0; i < length; i++)
	{
	    names[i] = String.valueOf(i);
	}

	return names;
    }


    /**
     * Return a string representing the indexed array element of the
     * target
     */
    public String getValue(int index)
    {
	try
	{
	    RemoteValue value = target.getElement(index);

	    if (value == null)
	    {
		return "null";
	    }
	    else
	    {
		return value.toString();
	    }
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return "<error>";
	}
    }


    /**
     * Returns a new Inspector on the indexed array element of the
     * target
     */
    public Inspector getInspector(int index)
    {
	try
	{
	    return Inspector.on(target.getElement(index));
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return null;
	}
    }
}
