/*
 * @(#)RemoteValueInspector.java	1.0alpha (17 Oct 1995)
 *
 * Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
 * Unpublished work.  All Rights Reserved.
 *
 * The software contained on this media is the property of the
 * DSTC Pty Ltd.  Use of this software is strictly in accordance
 * with the license agreement in the accompanying LICENSE.DOC file.
 * If your distribution of this software does not contain a
 * LICENSE.DOC file then you have no rights to use this software
 * in any manner and should contact DSTC at the address below
 * to determine an appropriate licensing arrangement.
 *
 *     DSTC Pty Ltd
 *     Level 7, Gehrmann Labs
 *     University of Queensland
 *     St Lucia, 4072
 *     Australia
 *     Tel: +61 7 3365 4310
 *     Fax: +61 7 3365 4311
 *     Email: enquiries@dstc.edu.au
 *
 * This software is being provided "AS IS" without warranty of
 * any kind.  In no event shall DSTC Pty Ltd be liable for
 * damage of any kind arising out of or in connection with
 * the use or performance of this software.
 */

package dstc.kalimantan.inspect;

import sun.tools.debug.*;

/** 
 * Inspector for basic RemoteValue objects
 *
 * @see		dstc.kalimantan.inspect.Inspector
 * @version	1.0alpha (17 Oct 1995)
 * @author	Ted Phelps
 */
public class RemoteValueInspector extends Inspector
{
    private RemoteValue target;

    /** Constructs a RemoteValueInspector on the object */
    public RemoteValueInspector(Object t)
    {
	target = (RemoteValue)t;
    }

    /** Returns the name of the target's class */
    public String getClassName()
    {
	try
	{
	    return target.typeName();
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return "<error>";
	}
    }


    /** Returns a string representing the target */
    public String getTarget()
    {
	return target.description();
    }


    /** 
     * Returns an empty array of strings - basic RemoteValue objects
     * do not have slots to inspect
     */
    public String[] getNames()
    {
	String names[] = new String[0];

	return names;
    }


    /** This should never be called */
    public String getValue(int index)
    {
	return null;
    }


    /** This should never be called */
    public Inspector getInspector(int index)
    {
	return null;
    }
}
