/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;
import java.util.Enumeration;
import dejava.sys.*;
import dejava.lang.AccessFlags;
import dejava.lang.MethodPrototype;

class BrowserMenuBar extends DejavaMenuBar {

    private DejavaMenu optionMenu;
    private DejavaMenu addPrototypeMenu;

    protected final static String MENU_GO_TO_LINE      = "go to line";
    protected final static String MENU_SPAWN_CHANGES   = "spawn changes";
    protected final static String MENU_SPAWN_FILE      = "spawn file";
    protected final static String MENU_NEW_CLASS       = "new class";
    protected final static String MENU_NEW_INTERFACE   = "new interface";
    protected final static String MENU_NEW_CONSTRUCTOR = "new constructor";
    protected final static String MENU_NEW_METHOD      = "new method";
    protected final static String MENU_SET_PROTOTYPE   = "set prototype";
    protected final static String MENU_NEW_PACKAGE     = "new package";
    protected final static String MENU_CHANGE_ORDER    = "change order";
    protected final static String MENU_REMOVE_PACKAGE  = "remove package";
    protected final static String MENU_REMOVE_CLASS    = "remove class";
    protected final static String MENU_REMOVE_METHOD   = "remove method";
    protected final static String MENU_RENAME 	       = "rename";
    protected final static String MENU_HIDE_CLASS_METHODS     = "hide class methods";
    protected final static String MENU_HIDE_INSTANCE_METHODS  = "hide instance methods";
    protected final static String MENU_HIDE_PUBLIC_METHODS    = "hide public methods";
    protected final static String MENU_HIDE_FRIENDLY_METHODS  = "hide friendly methods";
    protected final static String MENU_HIDE_PROTECTED_METHODS = "hide protected methods";
    protected final static String MENU_HIDE_PRIVATE_METHODS   = "hide private methods";

    protected DejavaMenu createOptionMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_OPTION, true);
	menu.addCheckboxItem(MENU_HIDE_CLASS_METHODS);
	menu.addCheckboxItem(MENU_HIDE_INSTANCE_METHODS);
	menu.addSeparator();
	menu.addCheckboxItem(MENU_HIDE_PUBLIC_METHODS);
	menu.addCheckboxItem(MENU_HIDE_FRIENDLY_METHODS);
	menu.addCheckboxItem(MENU_HIDE_PROTECTED_METHODS);
	menu.addCheckboxItem(MENU_HIDE_PRIVATE_METHODS);
	optionMenu = menu;
	return menu;
    }

    protected void createFileEditMenu(DejavaMenu menu) {
        menu.add(MENU_GO_TO_LINE);
        menu.addSeparator();
        menu.add(MENU_SPAWN_CHANGES);
        menu.add(MENU_SPAWN_FILE);
        menu.addSeparator();
    }

    protected void createPackageEditMenu(DejavaMenu menu) {
	menu.add(MENU_NEW_PACKAGE);
	menu.add(MENU_REMOVE_PACKAGE);
	menu.add(MENU_RENAME);
	menu.addSeparator();
    }

    protected void createClassEditMenu(DejavaMenu menu) {
	menu.add(MENU_NEW_CLASS);
	menu.add(MENU_NEW_INTERFACE);
	menu.add(MENU_REMOVE_CLASS);
	menu.add(MENU_RENAME);
	menu.addSeparator();
    }

    protected void createMethodEditMenu(DejavaMenu menu) {
	addPrototypeMenu = new DejavaMenu(MENU_SET_PROTOTYPE);
	Enumeration prototypes = new MethodPrototype();
	while (prototypes.hasMoreElements()) {
	    String prototype = (String)prototypes.nextElement();
	    if (prototype == null) {
		addPrototypeMenu.addSeparator();
	    } else {
		addPrototypeMenu.add(prototype);
	    }
	}

	menu.add(MENU_CHANGE_ORDER);
	menu.addSeparator();
	menu.add(MENU_NEW_CONSTRUCTOR);
	menu.add(MENU_NEW_METHOD);
	menu.add(addPrototypeMenu);
	menu.add(MENU_REMOVE_METHOD);
	menu.add(MENU_RENAME);
	menu.addSeparator();
    }

    protected void updateFileMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.classManager() != null || cp.methodManager() != null) {
	    menu.enable(MENU_SPAWN_FILE);
	} else {
	    menu.disable(MENU_SPAWN_FILE);
	}
	super.updateFileMenuActivity(menu, frame, cp);
    }

    protected void updatePackageMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.projectManager() == null) {
	    menu.disable(MENU_NEW_PACKAGE);
	} else {
	    menu.enable(MENU_NEW_PACKAGE);
	}
	if (cp.packageManager() == null) {
	    menu.disable(MENU_REMOVE_PACKAGE);
	    menu.disable(MENU_RENAME);
	} else {
	    menu.enable(MENU_REMOVE_PACKAGE);
	    menu.enable(MENU_RENAME);
	}
	super.updatePackageMenuActivity(menu, frame, cp);
    }

    protected void updateClassMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.packageManager() == null) {
	    menu.disable(MENU_NEW_CLASS);
	    menu.disable(MENU_NEW_INTERFACE);
	} else {
	    menu.enable(MENU_NEW_CLASS);
	    menu.enable(MENU_NEW_INTERFACE);
	}
	if (cp.classManager() == null) {
	    menu.disable(MENU_REMOVE_CLASS);
	    menu.disable(MENU_RENAME);
	} else {
	    menu.enable(MENU_REMOVE_CLASS);
	    menu.enable(MENU_RENAME);
	}
	super.updateClassMenuActivity(menu, frame, cp);
    }

    protected void updateMethodMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	ClassManager cm = cp.classManager();
	if (cm == null) {
	    menu.disable(MENU_CHANGE_ORDER);
	    menu.disable(MENU_NEW_CONSTRUCTOR);
	    menu.disable(MENU_NEW_METHOD);
	    addPrototypeMenu.disable();
	} else {
	    boolean isInterface = false;
	    try {
		if (cm.spec().isInterface()) isInterface = true;
	    } catch (DejavaException e) {
	    }
	    if (isInterface) {
		menu.disable(MENU_CHANGE_ORDER);
		menu.disable(MENU_NEW_CONSTRUCTOR);
		addPrototypeMenu.disable();
	    } else {
		menu.enable(MENU_CHANGE_ORDER);
		menu.enable(MENU_NEW_CONSTRUCTOR);
		addPrototypeMenu.enable();
	    }
	    menu.enable(MENU_NEW_METHOD);
	}
	if (cp.methodManager() == null ||
	    cp.methodManager() instanceof HeaderManager) {
	    menu.disable(MENU_REMOVE_METHOD);
	    menu.disable(MENU_RENAME);
	} else {
	    menu.enable(MENU_REMOVE_METHOD);
	    menu.enable(MENU_RENAME);
	}
	super.updateMethodMenuActivity(menu, frame, cp);
    }

    protected void actionFileMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_GO_TO_LINE)) {
	    (new LocationFrame(cp)).open();
        } else if (label.equals(MENU_SPAWN_CHANGES)) {
            ChangeListFrame.openOn(cp);
        } else if (label.equals(MENU_SPAWN_FILE)) {
	    SourceFileManager sfm = cp.sourceFileManager();
            (new DejavaFrame(new CodePath(sfm), "Source File '" + sfm.name() + "'")).open();
	} else {
	    super.actionFileMenu(label, frame, cp);
	}
    }

    protected void actionOptionMenu(String label, DejavaFrame frame, CodePath cp) {
	try {
	    ((Browser)frame).updateMethods();
	} catch (DejavaException e) {
	}
	super.actionOptionMenu(label, frame, cp);
    }

    protected void actionPackageMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_NEW_PACKAGE)) {
	    ((Browser)frame).newPackage(cp);
	} else if (label.equals(MENU_REMOVE_PACKAGE)) {
	    ((Browser)frame).remove(cp);
	} else if (label.equals(MENU_RENAME)) {
	    ((Browser)frame).rename(cp);
	} else {
	    super.actionPackageMenu(label, frame, cp);
	}
    }

    protected void actionClassMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_NEW_CLASS)) {
	    ((Browser)frame).newClass(cp, false);
	} else if (label.equals(MENU_NEW_INTERFACE)) {
	    ((Browser)frame).newClass(cp, true);
	} else if (label.equals(MENU_REMOVE_CLASS)) {
	    ((Browser)frame).remove(cp);
	} else if (label.equals(MENU_RENAME)) {
	    ((Browser)frame).rename(cp);
	} else {
	    super.actionClassMenu(label, frame, cp);
	}
    }

    protected void actionMethodMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_CHANGE_ORDER)) {
	    (new MethodOrder(frame, cp)).show();
	} else if (label.equals(MENU_NEW_CONSTRUCTOR)) {
	    ((Browser)frame).newMethod(cp, true);
	} else if (label.equals(MENU_NEW_METHOD)) {
	    ((Browser)frame).newMethod(cp, false);
	} else if (label.equals(MENU_REMOVE_METHOD)) {
	    ((Browser)frame).remove(cp);
	} else if (label.equals(MENU_RENAME)) {
	    ((Browser)frame).rename(cp);
	} else {
	    super.actionMethodMenu(label, frame, cp);
	}
    }

    boolean action(Event e, Object arg, DejavaFrame frame, CodePath cp)
					throws DejavaClassNotFoundException {
	if ((e.target instanceof MenuItem) &&
	    ((MenuItem)e.target).getParent() == addPrototypeMenu) {
	    ((Browser)frame).newMethod(cp, MethodPrototype.getDescription((String)arg));
	    return true;
	}
	return super.action(e, arg, frame, cp);
    }

    AccessFlags hideMethods() {
	AccessFlags hideMethods = new AccessFlags();
	if (optionMenu.getState(MENU_HIDE_CLASS_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.STATIC);
	}
	if (optionMenu.getState(MENU_HIDE_INSTANCE_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.NON_STATIC);
	}
	if (optionMenu.getState(MENU_HIDE_PUBLIC_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.PUBLIC);
	}
	if (optionMenu.getState(MENU_HIDE_FRIENDLY_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.FRIENDLY);
	}
	if (optionMenu.getState(MENU_HIDE_PROTECTED_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.PROTECTED);
	}
	if (optionMenu.getState(MENU_HIDE_PRIVATE_METHODS)) {
	    hideMethods.enableAccessFlags(AccessFlags.PRIVATE);
	}
	return hideMethods;
    }
}
