/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.*;
import java.io.File;
import java.util.Enumeration;
import java.awt.*;

public class ChangeListFrame extends ListingFrame {

    static void openOn(CodePath cp) {
	ChangeListFrame frame = new ChangeListFrame(cp);
	ChangeList changes = cp.projectManager().changes();
	int count = changes.count();
	if (count == 0) count = 100;
	String req = (new Integer(count)).toString();
	req = SystemManager.request("How many changes to be listed? ", req);
	if (req == null || req.trim().length() == 0) return;
	try {
	    count = Integer.parseInt(req);
	} catch (Exception e) {
	    count = 100;
	}
	try {
	    frame.start((new ChangeList(changes.file())).elementsFromFile(count, true));
	} catch (Exception e) {
	    SystemManager.information(changes.file().getPath() + ": " + e.getMessage());
	    return;
	}
	frame.open();
    }

    static void openOn(String fileName) {
	ChangeListFrame frame = new ChangeListFrame(fileName);
	ChangeList changes = new ChangeList(new File(fileName));
	try {
	    frame.start(changes.elementsFromFile(Integer.MAX_VALUE, false));
	} catch (Exception e) {
	    SystemManager.information(fileName + ": " + e.getMessage());
	    return;
	}
	frame.open();
    }

    public ChangeListFrame(CodePath cp) {
	super(cp, "Changes on: " + cp.projectName());
    }

    public ChangeListFrame(String fileName) {
	super(CodePath.nullCodePath, "Changes from: " + fileName);
    }

    protected DejavaMenuBar createMenuBar() {
	return new ChangeListMenuBar();
    }

    public boolean action(Event ev, Object arg) {
	if (ev.target != list) {
	    return super.action(ev, arg);
	}
	selection = list.getSelectedIndex();
        if (selection >= 0) {
	    current = itemAt(selection).codePath();
        } else {
	    current = CodePath.nullCodePath; 
	}
	updateCurrent();
	return true;
    }

    public void updateCode() {
        if (selection == -1) {
            setCode(getMessages());
	} else {
	    setCode(((Changes)itemAt(selection)).getCode());
	}
    }

    /**
     * accept code
     */
    protected boolean accept() {
	return doAccept();
    }

    void loadFromFile(boolean merge) {
	File f = startup.projectManager().changes().file();
	String fname = DejavaFileDialog.request(this, "Filename to load", f.getParent(), f.getName());
	if (fname == null) return;
	try {
	    Enumeration en = (new ChangeList(fname)).elementsFromFile(Integer.MAX_VALUE, true);
	    if (merge) {
		start(en);
	    } else {
		restart(en);
	    }
	} catch (Exception e) {
	    SystemManager.information(fname + ": " + e.getMessage());
	}
    }

    void saveIntoFile(boolean marked) {
	String fname = DejavaFileDialog.request(this, "Filename to save");
	if (fname == null) return;
	ChangeList cl = new ChangeList(fname);
	Enumeration en = itemElements();
	while (en.hasMoreElements()) {
	    Changes chg = (Changes)en.nextElement();
	    if (!marked || chg.isMarked()) {
		try {
		    cl.addChanges(chg.codePath(), chg.action(), chg.getCode());
		} catch (Exception e) {
		    SystemManager.information(fname + ": " +
					  chg.codePath().printString() + ": " +
					  e.getMessage());
		}
	    }
	}
    }

    public ListingFrame copyCreate(CodePath cp) {
	return new ChangeListFrame(cp);
    }
}
