/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.gui;

import dejava.sys.CodePath;

class ChangeListMenuBar extends ListingMenuBar {

    protected static final String MENU_LOAD_OVERLOAD = "load(overload)";
    protected static final String MENU_LOAD_MERGE    = "load(merge)";
    protected static final String MENU_SAVE_ALL      = "save all";
    protected static final String MENU_SAVE_MARKED   = "save marked";

    protected boolean createFileEditMoreMenu(DejavaMenu menu) {
	menu.add(MENU_LOAD_OVERLOAD);
	menu.add(MENU_LOAD_MERGE);
	menu.add(MENU_SAVE_ALL);
	menu.add(MENU_SAVE_MARKED);
	return false;
    }

    protected void actionFileMenu(String label, DejavaFrame frame, CodePath cp) {
	ChangeListFrame clf = (ChangeListFrame)frame;
	if (label.equals(MENU_LOAD_OVERLOAD)) {
	    clf.loadFromFile(false);
	} else if (label.equals(MENU_LOAD_MERGE)) {
	    clf.loadFromFile(true);
	} else if (label.equals(MENU_SAVE_ALL)) {
	    clf.saveIntoFile(false);
	} else if (label.equals(MENU_SAVE_MARKED)) {
	    clf.saveIntoFile(true);
	} else {
	    super.actionFileMenu(label, frame, cp);
	}
    }
}
